/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.DBCursor;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class Domain {
    private String name;
    private Sequoiadb sequoiadb;

    public String getName() {
        return this.name;
    }

    public Sequoiadb getSequoiadb() {
        return this.sequoiadb;
    }

    Domain(Sequoiadb sequoiadb, String name) {
        this.name = name;
        this.sequoiadb = sequoiadb;
    }

    public void alterDomain(BSONObject options) throws BaseException {
        if (null == options) {
            throw new BaseException("SDB_INVALIDARG", options);
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.put("Name", (Object)this.name);
        newObj.put("Options", (Object)options);
        SDBMessage rtn = this.sequoiadb.adminCommand("alter domain", 0, 0L, 0L, -1L, newObj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, new Object[0]);
        }
    }

    public DBCursor listCSInDomain() throws BaseException {
        return this.listCSCL(11);
    }

    public DBCursor listCLInDomain() throws BaseException {
        return this.listCSCL(12);
    }

    private DBCursor listCSCL(int type) throws BaseException {
        BasicBSONObject matcher = new BasicBSONObject();
        BasicBSONObject selector = new BasicBSONObject();
        matcher.put("Domain", (Object)this.name);
        selector.put("Name", (Object)null);
        DBCursor cursor = this.sequoiadb.getList(type, matcher, selector, null);
        return cursor;
    }
}

