/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.DBCollection;
import com.sequoiadb.base.DBLob;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.SequoiadbConstants;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.util.Helper;
import com.sequoiadb.util.SDBMessageHelper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.ObjectId;

class DBLobConcrete
implements DBLob {
    public static final int SDB_LOB_CREATEONLY = 1;
    public static final int SDB_LOB_READ = 4;
    private static final int SDB_LOB_MAX_DATA_LENGTH = 0x100000;
    private static final long SDB_LOB_DEFAULT_OFFSET = -1L;
    private static final int SDB_LOB_DEFAULT_SEQ = 0;
    private DBCollection _cl;
    private ObjectId _id;
    private int _mode;
    private long _size;
    private long _createTime;
    private long _readOffset = 0L;
    private boolean _endianConvert;
    private boolean _isOpen = false;
    private long _contextID;

    public DBLobConcrete(DBCollection cl) throws BaseException {
        if (cl == null) {
            throw new BaseException("SDB_INVALIDARG", "cl is null");
        }
        this._cl = cl;
        this._endianConvert = cl.getSequoiadb().endianConvert;
    }

    public void open() {
        this.open(null, 1);
    }

    public void open(ObjectId id) {
        this.open(id, 4);
    }

    public void open(ObjectId id, int mode) throws BaseException {
        if (this._isOpen) {
            throw new BaseException("SDB_INVALIDARG", "lob have opened:id=" + this._id);
        }
        if (1 != mode && 4 != mode) {
            throw new BaseException("SDB_INVALIDARG", "mode is unsupported:" + mode);
        }
        if (4 == mode && null == id) {
            throw new BaseException("SDB_INVALIDARG", "id must be specify in mode:" + mode);
        }
        this._id = id;
        if (1 == mode && null == this._id) {
            this._id = ObjectId.get();
        }
        this._mode = mode;
        this._readOffset = 0L;
        this._open();
        this._isOpen = true;
    }

    private void _open() throws BaseException {
        BasicBSONObject openLob = new BasicBSONObject();
        openLob.put("Collection", (Object)this._cl.getFullName());
        openLob.put("Oid", (Object)this._id);
        openLob.put("Mode", (Object)this._mode);
        byte[] request = this.generateOpenLobRequest(openLob);
        ByteBuffer res = this.sendRequest(request, request.length);
        SDBMessage resMessage = SDBMessageHelper.msgExtractLobOpenReply(res);
        this.displayResponse(resMessage);
        if (resMessage.getOperationCode() != SequoiadbConstants.Operation.MSG_BS_LOB_OPEN_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{resMessage.getOperationCode()});
        }
        int flag = resMessage.getFlags();
        if (0 != flag) {
            throw new BaseException(flag, openLob);
        }
        List<BSONObject> objList = resMessage.getObjectList();
        if (objList.size() != 1) {
            throw new BaseException("SDB_NET_BROKEN_MSG", "objList.size()=" + objList.size());
        }
        BSONObject obj = objList.get(0);
        this._size = (Long)obj.get("Size");
        this._createTime = (Long)obj.get("CreateTime");
        this._contextID = resMessage.getContextIDList().get(0);
    }

    private ByteBuffer sendRequest(byte[] request, int length) throws BaseException {
        if (request == null) {
            throw new BaseException("SDB_INVALIDARG", "request can't be null");
        }
        this._cl.getConnection().sendMessage(request, length);
        return this._cl.getConnection().receiveMessage(this._endianConvert);
    }

    @Override
    public ObjectId getID() {
        return this._id;
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void close() throws BaseException {
        if (!this._isOpen) {
            return;
        }
        byte[] request = this.generateCloseLobRequest();
        ByteBuffer res = this.sendRequest(request, request.length);
        SDBMessage resMessage = SDBMessageHelper.msgExtractReply(res);
        this.displayResponse(resMessage);
        if (resMessage.getOperationCode() != SequoiadbConstants.Operation.MSG_BS_LOB_CLOSE_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{resMessage.getOperationCode()});
        }
        int flag = resMessage.getFlags();
        if (0 != flag) {
            throw new BaseException(flag, new Object[0]);
        }
        this._isOpen = false;
    }

    @Override
    public void write(byte[] b) throws BaseException {
        int writeLen;
        if (!this._isOpen) {
            throw new BaseException("SDB_LOB_NOT_OPEN", "lob is not open");
        }
        if (b == null) {
            throw new BaseException("SDB_INVALIDARG", "input is null");
        }
        if (b.length <= 0x100000) {
            this._write(b);
            return;
        }
        for (int offset = 0; b.length > offset; offset += writeLen) {
            int leftLen = b.length - offset;
            writeLen = leftLen > 0x100000 ? 0x100000 : leftLen;
            byte[] tempb = new byte[writeLen];
            int j = 0;
            for (int i = offset; i < offset + writeLen; ++i) {
                tempb[j] = b[i];
                ++j;
            }
            this._write(tempb);
        }
    }

    @Override
    public int read(byte[] b) throws BaseException {
        if (!this._isOpen) {
            throw new BaseException("SDB_LOB_NOT_OPEN", "lob is not open");
        }
        if (b == null) {
            throw new BaseException("SDB_INVALIDARG", "b is null");
        }
        if (b.length == 0) {
            return 0;
        }
        return this._read(b);
    }

    @Override
    public void seek(long size, int seekType) throws BaseException {
        if (!this._isOpen) {
            throw new BaseException("SDB_LOB_NOT_OPEN", "lob is not open");
        }
        if (this._mode != 4) {
            throw new BaseException("SDB_INVALIDARG", "seek() is not supportedin mode=" + this._mode);
        }
        if (0 == seekType) {
            if (size < 0L || size > this._size) {
                throw new BaseException("SDB_INVALIDARG", "out of bound");
            }
            this._readOffset = size;
        } else if (1 == seekType) {
            if (this._size < this._readOffset + size || this._readOffset + size < 0L) {
                throw new BaseException("SDB_INVALIDARG", "out of bound");
            }
            this._readOffset += size;
        } else if (2 == seekType) {
            if (size < 0L || size > this._size) {
                throw new BaseException("SDB_INVALIDARG", "out of bound");
            }
            this._readOffset = this._size - size;
        } else {
            throw new BaseException("SDB_INVALIDARG", "unreconigzed seekType:" + seekType);
        }
    }

    private int _read(byte[] b) {
        byte[] request = this.generateReadLobRequest(b.length);
        ByteBuffer res = this.sendRequest(request, request.length);
        SDBMessage resMessage = SDBMessageHelper.msgExtractLobReadReply(res);
        this.displayResponse(resMessage);
        if (resMessage.getOperationCode() != SequoiadbConstants.Operation.MSG_BS_LOB_READ_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{resMessage.getOperationCode()});
        }
        int flag = resMessage.getFlags();
        if (SequoiadbConstants.SDB_EOF == flag) {
            return -1;
        }
        if (0 != flag) {
            throw new BaseException(flag, new Object[0]);
        }
        byte[] lobData = resMessage.getLobBuff();
        for (int i = 0; i < lobData.length; ++i) {
            b[i] = lobData[i];
        }
        this._readOffset += (long)lobData.length;
        return lobData.length;
    }

    private byte[] generateReadLobRequest(int length) {
        int totalLen = 68;
        ByteBuffer buff = ByteBuffer.allocate(68);
        if (this._endianConvert) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buff.order(ByteOrder.BIG_ENDIAN);
        }
        SDBMessageHelper.addLobMsgHeader(buff, totalLen, SequoiadbConstants.Operation.MSG_BS_LOB_READ_REQ.getOperationCode(), SequoiadbConstants.ZERO_NODEID, 0L);
        SDBMessageHelper.addLobOpMsg(buff, 0, (short)1, (short)0, 0, this._contextID, 0);
        this.addMsgTuple(buff, length, 0, this._readOffset);
        return buff.array();
    }

    private void _write(byte[] input) throws BaseException {
        byte[] request = this.generateWriteLobRequest(input);
        ByteBuffer res = this.sendRequest(request, request.length);
        SDBMessage resMessage = SDBMessageHelper.msgExtractReply(res);
        this.displayResponse(resMessage);
        if (resMessage.getOperationCode() != SequoiadbConstants.Operation.MSG_BS_LOB_WRITE_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{resMessage.getOperationCode()});
        }
        int flag = resMessage.getFlags();
        if (0 != flag) {
            throw new BaseException(flag, new Object[0]);
        }
        this._size += (long)input.length;
    }

    private byte[] generateWriteLobRequest(byte[] input) {
        int totalLen = 68 + Helper.roundToMultipleXLength(input.length, 4);
        ByteBuffer buff = ByteBuffer.allocate(68);
        if (this._endianConvert) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buff.order(ByteOrder.BIG_ENDIAN);
        }
        SDBMessageHelper.addLobMsgHeader(buff, totalLen, SequoiadbConstants.Operation.MSG_BS_LOB_WRITE_REQ.getOperationCode(), SequoiadbConstants.ZERO_NODEID, 0L);
        SDBMessageHelper.addLobOpMsg(buff, 0, (short)1, (short)0, 0, this._contextID, 0);
        this.addMsgTuple(buff, input.length, 0, -1L);
        ArrayList<byte[]> buffList = new ArrayList<byte[]>();
        buffList.add(buff.array());
        buffList.add(Helper.roundToMultipleX(input, 4));
        return Helper.concatByteArray(buffList);
    }

    private void addMsgTuple(ByteBuffer buff, int length, int sequence, long offset) {
        buff.putInt(length);
        buff.putInt(sequence);
        buff.putLong(offset);
    }

    private byte[] generateCloseLobRequest() {
        int totalLen = 52;
        ByteBuffer buff = ByteBuffer.allocate(52);
        if (this._endianConvert) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buff.order(ByteOrder.BIG_ENDIAN);
        }
        SDBMessageHelper.addLobMsgHeader(buff, totalLen, SequoiadbConstants.Operation.MSG_BS_LOB_CLOSE_REQ.getOperationCode(), SequoiadbConstants.ZERO_NODEID, 0L);
        SDBMessageHelper.addLobOpMsg(buff, 0, (short)1, (short)0, 0, this._contextID, 0);
        return buff.array();
    }

    private byte[] generateOpenLobRequest(BSONObject openLob) {
        byte[] bOpenLob = SDBMessageHelper.bsonObjectToByteArray(openLob);
        int totalLen = 52 + Helper.roundToMultipleXLength(bOpenLob.length, 4);
        if (!this._endianConvert) {
            SDBMessageHelper.bsonEndianConvert(bOpenLob, 0, bOpenLob.length, true);
        }
        ByteBuffer buff = ByteBuffer.allocate(52);
        if (this._endianConvert) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buff.order(ByteOrder.BIG_ENDIAN);
        }
        SDBMessageHelper.addLobMsgHeader(buff, totalLen, SequoiadbConstants.Operation.MSG_BS_LOB_OPEN_REQ.getOperationCode(), SequoiadbConstants.ZERO_NODEID, 0L);
        SDBMessageHelper.addLobOpMsg(buff, 0, (short)1, (short)0, 0, -1L, bOpenLob.length);
        ArrayList<byte[]> buffList = new ArrayList<byte[]>();
        buffList.add(buff.array());
        buffList.add(Helper.roundToMultipleX(bOpenLob, 4));
        return Helper.concatByteArray(buffList);
    }

    private void displayResponse(SDBMessage resMessage) {
    }
}

