package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Failover}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFailover.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Failover"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFailover extends Failover {
  private final Optional<Integer> nearestN;
  private final Optional<String> datacenters;

  private ImmutableFailover(
      Optional<Integer> nearestN,
      Optional<String> datacenters) {
    this.nearestN = nearestN;
    this.datacenters = datacenters;
  }

  /**
   * @return The value of the {@code nearestN} attribute
   */
  @JsonProperty(value = "NearestN")
  @Override
  public Optional<Integer> getNearestN() {
    return nearestN;
  }

  /**
   * @return The value of the {@code datacenters} attribute
   */
  @JsonProperty(value = "Datacenters")
  @Override
  public Optional<String> datacenters() {
    return datacenters;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Failover#getNearestN() nearestN} attribute.
   * @param value The value for nearestN
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFailover withNearestN(int value) {
    Optional<Integer> newValue = Optional.of(value);
    if (this.nearestN.equals(newValue)) return this;
    return new ImmutableFailover(newValue, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Failover#getNearestN() nearestN} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nearestN
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFailover withNearestN(Optional<Integer> optional) {
    Optional<Integer> value = Preconditions.checkNotNull(optional, "nearestN");
    if (this.nearestN.equals(value)) return this;
    return new ImmutableFailover(value, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Failover#datacenters() datacenters} attribute.
   * @param value The value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFailover withDatacenters(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.datacenters.equals(newValue)) return this;
    return new ImmutableFailover(this.nearestN, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Failover#datacenters() datacenters} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFailover withDatacenters(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "datacenters");
    if (this.datacenters.equals(value)) return this;
    return new ImmutableFailover(this.nearestN, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFailover} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFailover
        && equalTo((ImmutableFailover) another);
  }

  private boolean equalTo(ImmutableFailover another) {
    return nearestN.equals(another.nearestN)
        && datacenters.equals(another.datacenters);
  }

  /**
   * Computes a hash code from attributes: {@code nearestN}, {@code datacenters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + nearestN.hashCode();
    h = h * 17 + datacenters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Failover} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Failover")
        .omitNullValues()
        .add("nearestN", nearestN.orNull())
        .add("datacenters", datacenters.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Failover {
    Optional<Integer> nearestN = Optional.absent();
    Optional<String> datacenters = Optional.absent();
    @JsonProperty(value = "NearestN")
    public void setNearestN(Optional<Integer> nearestN) {
      this.nearestN = nearestN;
    }
    @JsonProperty(value = "Datacenters")
    public void setDatacenters(Optional<String> datacenters) {
      this.datacenters = datacenters;
    }
    @Override
    public Optional<Integer> getNearestN() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> datacenters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableFailover fromJson(Json json) {
    ImmutableFailover.Builder builder = ImmutableFailover.builder();
    if (json.nearestN != null) {
      builder.nearestN(json.nearestN);
    }
    if (json.datacenters != null) {
      builder.datacenters(json.datacenters);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Failover} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Failover instance
   */
  public static ImmutableFailover copyOf(Failover instance) {
    if (instance instanceof ImmutableFailover) {
      return (ImmutableFailover) instance;
    }
    return ImmutableFailover.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFailover ImmutableFailover}.
   * @return A new ImmutableFailover builder
   */
  public static ImmutableFailover.Builder builder() {
    return new ImmutableFailover.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFailover ImmutableFailover}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private Optional<Integer> nearestN = Optional.absent();
    private Optional<String> datacenters = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Failover} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Failover instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<Integer> nearestNOptional = instance.getNearestN();
      if (nearestNOptional.isPresent()) {
        nearestN(nearestNOptional);
      }
      Optional<String> datacentersOptional = instance.datacenters();
      if (datacentersOptional.isPresent()) {
        datacenters(datacentersOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Failover#getNearestN() nearestN} to nearestN.
     * @param nearestN The value for nearestN
     * @return {@code this} builder for chained invocation
     */
    public final Builder nearestN(int nearestN) {
      this.nearestN = Optional.of(nearestN);
      return this;
    }

    /**
     * Initializes the optional value {@link Failover#getNearestN() nearestN} to nearestN.
     * @param nearestN The value for nearestN
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nearestN(Optional<Integer> nearestN) {
      this.nearestN = Preconditions.checkNotNull(nearestN, "nearestN");
      return this;
    }

    /**
     * Initializes the optional value {@link Failover#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenters(String datacenters) {
      this.datacenters = Optional.of(datacenters);
      return this;
    }

    /**
     * Initializes the optional value {@link Failover#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenters(Optional<String> datacenters) {
      this.datacenters = Preconditions.checkNotNull(datacenters, "datacenters");
      return this;
    }

    /**
     * Builds a new {@link ImmutableFailover ImmutableFailover}.
     * @return An immutable instance of Failover
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFailover build() {
      return new ImmutableFailover(nearestN, datacenters);
    }
  }
}
