package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.util.Base64EncodingDeserializer;
import com.orbitz.consul.util.Base64EncodingSerializer;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Operation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOperation.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Operation"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableOperation extends Operation {
  private final String verb;
  private final Optional<String> key;
  private final Optional<String> value;
  private final Optional<Long> flags;
  private final Optional<BigInteger> index;
  private final Optional<String> session;

  private ImmutableOperation(
      String verb,
      Optional<String> key,
      Optional<String> value,
      Optional<Long> flags,
      Optional<BigInteger> index,
      Optional<String> session) {
    this.verb = verb;
    this.key = key;
    this.value = value;
    this.flags = flags;
    this.index = index;
    this.session = session;
  }

  /**
   * @return The value of the {@code verb} attribute
   */
  @JsonProperty(value = "Verb")
  @Override
  public String verb() {
    return verb;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty(value = "Key")
  @Override
  public Optional<String> key() {
    return key;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty(value = "Value")
  @JsonSerialize(using = Base64EncodingSerializer.class)
  @JsonDeserialize(using = Base64EncodingDeserializer.class)
  @Override
  public Optional<String> value() {
    return value;
  }

  /**
   * @return The value of the {@code flags} attribute
   */
  @JsonProperty(value = "Flags")
  @Override
  public Optional<Long> flags() {
    return flags;
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @JsonProperty(value = "Index")
  @Override
  public Optional<BigInteger> index() {
    return index;
  }

  /**
   * @return The value of the {@code session} attribute
   */
  @JsonProperty(value = "Session")
  @Override
  public Optional<String> session() {
    return session;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation#verb() verb} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verb
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOperation withVerb(String value) {
    if (this.verb.equals(value)) return this;
    return new ImmutableOperation(
        Preconditions.checkNotNull(value, "verb"),
        this.key,
        this.value,
        this.flags,
        this.index,
        this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#key() key} attribute.
   * @param value The value for key
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withKey(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.key.equals(newValue)) return this;
    return new ImmutableOperation(this.verb, newValue, this.value, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#key() key} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for key
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withKey(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "key");
    if (this.key.equals(value)) return this;
    return new ImmutableOperation(this.verb, value, this.value, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#value() value} attribute.
   * @param value The value for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withValue(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.value.equals(newValue)) return this;
    return new ImmutableOperation(this.verb, this.key, newValue, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#value() value} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withValue(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "value");
    if (this.value.equals(value)) return this;
    return new ImmutableOperation(this.verb, this.key, value, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#flags() flags} attribute.
   * @param value The value for flags
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withFlags(long value) {
    Optional<Long> newValue = Optional.of(value);
    if (this.flags.equals(newValue)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, newValue, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#flags() flags} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for flags
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withFlags(Optional<Long> optional) {
    Optional<Long> value = Preconditions.checkNotNull(optional, "flags");
    if (this.flags.equals(value)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, value, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#index() index} attribute.
   * @param value The value for index
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withIndex(BigInteger value) {
    Optional<BigInteger> newValue = Optional.of(value);
    if (this.index.isPresent() && this.index.get() == value) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, this.flags, newValue, this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#index() index} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for index
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withIndex(Optional<BigInteger> optional) {
    Optional<BigInteger> value = Preconditions.checkNotNull(optional, "index");
    if (!this.index.isPresent() && !value.isPresent()) return this;
    if (this.index.isPresent() && value.isPresent() && this.index.get() == value.get()) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, this.flags, value, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#session() session} attribute.
   * @param value The value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withSession(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.session.equals(newValue)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#session() session} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withSession(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "session");
    if (this.session.equals(value)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOperation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOperation
        && equalTo((ImmutableOperation) another);
  }

  private boolean equalTo(ImmutableOperation another) {
    return verb.equals(another.verb)
        && key.equals(another.key)
        && value.equals(another.value)
        && flags.equals(another.flags)
        && index.equals(another.index)
        && session.equals(another.session);
  }

  /**
   * Computes a hash code from attributes: {@code verb}, {@code key}, {@code value}, {@code flags}, {@code index}, {@code session}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + verb.hashCode();
    h = h * 17 + key.hashCode();
    h = h * 17 + value.hashCode();
    h = h * 17 + flags.hashCode();
    h = h * 17 + index.hashCode();
    h = h * 17 + session.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Operation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Operation")
        .omitNullValues()
        .add("verb", verb)
        .add("key", key.orNull())
        .add("value", value.orNull())
        .add("flags", flags.orNull())
        .add("index", index.orNull())
        .add("session", session.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Operation {
    @Nullable String verb;
    Optional<String> key = Optional.absent();
    Optional<String> value = Optional.absent();
    Optional<Long> flags = Optional.absent();
    Optional<BigInteger> index = Optional.absent();
    Optional<String> session = Optional.absent();
    @JsonProperty(value = "Verb")
    public void setVerb(String verb) {
      this.verb = verb;
    }
    @JsonProperty(value = "Key")
    public void setKey(Optional<String> key) {
      this.key = key;
    }
    @JsonProperty(value = "Value")
    @JsonSerialize(using = Base64EncodingSerializer.class)
    @JsonDeserialize(using = Base64EncodingDeserializer.class)
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty(value = "Flags")
    public void setFlags(Optional<Long> flags) {
      this.flags = flags;
    }
    @JsonProperty(value = "Index")
    public void setIndex(Optional<BigInteger> index) {
      this.index = index;
    }
    @JsonProperty(value = "Session")
    public void setSession(Optional<String> session) {
      this.session = session;
    }
    @Override
    public String verb() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> key() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> value() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Long> flags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<BigInteger> index() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> session() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableOperation fromJson(Json json) {
    ImmutableOperation.Builder builder = ImmutableOperation.builder();
    if (json.verb != null) {
      builder.verb(json.verb);
    }
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.flags != null) {
      builder.flags(json.flags);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    if (json.session != null) {
      builder.session(json.session);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Operation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Operation instance
   */
  public static ImmutableOperation copyOf(Operation instance) {
    if (instance instanceof ImmutableOperation) {
      return (ImmutableOperation) instance;
    }
    return ImmutableOperation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOperation ImmutableOperation}.
   * @return A new ImmutableOperation builder
   */
  public static ImmutableOperation.Builder builder() {
    return new ImmutableOperation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOperation ImmutableOperation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VERB = 0x1L;
    private long initBits = 0x1;

    private @Nullable String verb;
    private Optional<String> key = Optional.absent();
    private Optional<String> value = Optional.absent();
    private Optional<Long> flags = Optional.absent();
    private Optional<BigInteger> index = Optional.absent();
    private Optional<String> session = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Operation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Operation instance) {
      Preconditions.checkNotNull(instance, "instance");
      verb(instance.verb());
      Optional<String> keyOptional = instance.key();
      if (keyOptional.isPresent()) {
        key(keyOptional);
      }
      Optional<String> valueOptional = instance.value();
      if (valueOptional.isPresent()) {
        value(valueOptional);
      }
      Optional<Long> flagsOptional = instance.flags();
      if (flagsOptional.isPresent()) {
        flags(flagsOptional);
      }
      Optional<BigInteger> indexOptional = instance.index();
      if (indexOptional.isPresent()) {
        index(indexOptional);
      }
      Optional<String> sessionOptional = instance.session();
      if (sessionOptional.isPresent()) {
        session(sessionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Operation#verb() verb} attribute.
     * @param verb The value for verb 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verb(String verb) {
      this.verb = Preconditions.checkNotNull(verb, "verb");
      initBits &= ~INIT_BIT_VERB;
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#key() key} to key.
     * @param key The value for key
     * @return {@code this} builder for chained invocation
     */
    public final Builder key(String key) {
      this.key = Optional.of(key);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#key() key} to key.
     * @param key The value for key
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(Optional<String> key) {
      this.key = Preconditions.checkNotNull(key, "key");
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#value() value} to value.
     * @param value The value for value
     * @return {@code this} builder for chained invocation
     */
    public final Builder value(String value) {
      this.value = Optional.of(value);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#value() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(Optional<String> value) {
      this.value = Preconditions.checkNotNull(value, "value");
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#flags() flags} to flags.
     * @param flags The value for flags
     * @return {@code this} builder for chained invocation
     */
    public final Builder flags(long flags) {
      this.flags = Optional.of(flags);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#flags() flags} to flags.
     * @param flags The value for flags
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder flags(Optional<Long> flags) {
      this.flags = Preconditions.checkNotNull(flags, "flags");
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#index() index} to index.
     * @param index The value for index
     * @return {@code this} builder for chained invocation
     */
    public final Builder index(BigInteger index) {
      this.index = Optional.of(index);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#index() index} to index.
     * @param index The value for index
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(Optional<BigInteger> index) {
      this.index = Preconditions.checkNotNull(index, "index");
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#session() session} to session.
     * @param session The value for session
     * @return {@code this} builder for chained invocation
     */
    public final Builder session(String session) {
      this.session = Optional.of(session);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#session() session} to session.
     * @param session The value for session
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder session(Optional<String> session) {
      this.session = Preconditions.checkNotNull(session, "session");
      return this;
    }

    /**
     * Builds a new {@link ImmutableOperation ImmutableOperation}.
     * @return An immutable instance of Operation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOperation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOperation(verb, key, value, flags, index, session);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_VERB) != 0) attributes.add("verb");
      return "Cannot build Operation, some of required attributes are not set " + attributes;
    }
  }
}
