package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Check;
import com.orbitz.consul.model.health.Service;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link CatalogRegistration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalogRegistration.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "CatalogRegistration"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCatalogRegistration extends CatalogRegistration {
  private final Optional<String> datacenter;
  private final String node;
  private final String address;
  private final Optional<TaggedAddresses> taggedAddresses;
  private final Optional<Service> service;
  private final Optional<Check> check;
  private final Optional<WriteRequest> writeRequest;

  private ImmutableCatalogRegistration(
      Optional<String> datacenter,
      String node,
      String address,
      Optional<TaggedAddresses> taggedAddresses,
      Optional<Service> service,
      Optional<Check> check,
      Optional<WriteRequest> writeRequest) {
    this.datacenter = datacenter;
    this.node = node;
    this.address = address;
    this.taggedAddresses = taggedAddresses;
    this.service = service;
    this.check = check;
    this.writeRequest = writeRequest;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty(value = "Datacenter")
  @Override
  public Optional<String> datacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty(value = "Node")
  @Override
  public String node() {
    return node;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty(value = "Address")
  @Override
  public String address() {
    return address;
  }

  /**
   * @return The value of the {@code taggedAddresses} attribute
   */
  @JsonProperty(value = "TaggedAddresses")
  @Override
  public Optional<TaggedAddresses> taggedAddresses() {
    return taggedAddresses;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty(value = "Service")
  @Override
  public Optional<Service> service() {
    return service;
  }

  /**
   * @return The value of the {@code check} attribute
   */
  @JsonProperty(value = "Check")
  @Override
  public Optional<Check> check() {
    return check;
  }

  /**
   * @return The value of the {@code writeRequest} attribute
   */
  @JsonProperty(value = "WriteRequest")
  @Override
  public Optional<WriteRequest> writeRequest() {
    return writeRequest;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#datacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withDatacenter(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.datacenter.equals(newValue)) return this;
    return new ImmutableCatalogRegistration(
        newValue,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#datacenter() datacenter} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withDatacenter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "datacenter");
    if (this.datacenter.equals(value)) return this;
    return new ImmutableCatalogRegistration(
        value,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogRegistration#node() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogRegistration withNode(String value) {
    if (this.node.equals(value)) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        Preconditions.checkNotNull(value, "node"),
        this.address,
        this.taggedAddresses,
        this.service,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogRegistration#address() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogRegistration withAddress(String value) {
    if (this.address.equals(value)) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        Preconditions.checkNotNull(value, "address"),
        this.taggedAddresses,
        this.service,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#taggedAddresses() taggedAddresses} attribute.
   * @param value The value for taggedAddresses
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withTaggedAddresses(TaggedAddresses value) {
    Optional<TaggedAddresses> newValue = Optional.of(value);
    if (this.taggedAddresses.isPresent() && this.taggedAddresses.get() == value) return this;
    return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, newValue, this.service, this.check, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#taggedAddresses() taggedAddresses} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for taggedAddresses
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withTaggedAddresses(Optional<TaggedAddresses> optional) {
    Optional<TaggedAddresses> value = Preconditions.checkNotNull(optional, "taggedAddresses");
    if (!this.taggedAddresses.isPresent() && !value.isPresent()) return this;
    if (this.taggedAddresses.isPresent() && value.isPresent() && this.taggedAddresses.get() == value.get()) return this;
    return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, value, this.service, this.check, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#service() service} attribute.
   * @param value The value for service
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withService(Service value) {
    Optional<Service> newValue = Optional.of(value);
    if (this.service.isPresent() && this.service.get() == value) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        newValue,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#service() service} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for service
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withService(Optional<Service> optional) {
    Optional<Service> value = Preconditions.checkNotNull(optional, "service");
    if (!this.service.isPresent() && !value.isPresent()) return this;
    if (this.service.isPresent() && value.isPresent() && this.service.get() == value.get()) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        value,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#check() check} attribute.
   * @param value The value for check
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withCheck(Check value) {
    Optional<Check> newValue = Optional.of(value);
    if (this.check.isPresent() && this.check.get() == value) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        newValue,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#check() check} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for check
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withCheck(Optional<Check> optional) {
    Optional<Check> value = Preconditions.checkNotNull(optional, "check");
    if (!this.check.isPresent() && !value.isPresent()) return this;
    if (this.check.isPresent() && value.isPresent() && this.check.get() == value.get()) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        value,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#writeRequest() writeRequest} attribute.
   * @param value The value for writeRequest
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withWriteRequest(WriteRequest value) {
    Optional<WriteRequest> newValue = Optional.of(value);
    if (this.writeRequest.isPresent() && this.writeRequest.get() == value) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        this.check,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#writeRequest() writeRequest} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for writeRequest
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withWriteRequest(Optional<WriteRequest> optional) {
    Optional<WriteRequest> value = Preconditions.checkNotNull(optional, "writeRequest");
    if (!this.writeRequest.isPresent() && !value.isPresent()) return this;
    if (this.writeRequest.isPresent() && value.isPresent() && this.writeRequest.get() == value.get()) return this;
    return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, this.check, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalogRegistration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalogRegistration
        && equalTo((ImmutableCatalogRegistration) another);
  }

  private boolean equalTo(ImmutableCatalogRegistration another) {
    return datacenter.equals(another.datacenter)
        && node.equals(another.node)
        && address.equals(another.address)
        && taggedAddresses.equals(another.taggedAddresses)
        && service.equals(another.service)
        && check.equals(another.check)
        && writeRequest.equals(another.writeRequest);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code node}, {@code address}, {@code taggedAddresses}, {@code service}, {@code check}, {@code writeRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + node.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + taggedAddresses.hashCode();
    h = h * 17 + service.hashCode();
    h = h * 17 + check.hashCode();
    h = h * 17 + writeRequest.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CatalogRegistration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogRegistration")
        .omitNullValues()
        .add("datacenter", datacenter.orNull())
        .add("node", node)
        .add("address", address)
        .add("taggedAddresses", taggedAddresses.orNull())
        .add("service", service.orNull())
        .add("check", check.orNull())
        .add("writeRequest", writeRequest.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends CatalogRegistration {
    Optional<String> datacenter = Optional.absent();
    @Nullable String node;
    @Nullable String address;
    Optional<TaggedAddresses> taggedAddresses = Optional.absent();
    Optional<Service> service = Optional.absent();
    Optional<Check> check = Optional.absent();
    Optional<WriteRequest> writeRequest = Optional.absent();
    @JsonProperty(value = "Datacenter")
    public void setDatacenter(Optional<String> datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty(value = "Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty(value = "Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty(value = "TaggedAddresses")
    public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
      this.taggedAddresses = taggedAddresses;
    }
    @JsonProperty(value = "Service")
    public void setService(Optional<Service> service) {
      this.service = service;
    }
    @JsonProperty(value = "Check")
    public void setCheck(Optional<Check> check) {
      this.check = check;
    }
    @JsonProperty(value = "WriteRequest")
    public void setWriteRequest(Optional<WriteRequest> writeRequest) {
      this.writeRequest = writeRequest;
    }
    @Override
    public Optional<String> datacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String node() { throw new UnsupportedOperationException(); }
    @Override
    public String address() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<TaggedAddresses> taggedAddresses() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Service> service() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Check> check() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<WriteRequest> writeRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableCatalogRegistration fromJson(Json json) {
    ImmutableCatalogRegistration.Builder builder = ImmutableCatalogRegistration.builder();
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.taggedAddresses != null) {
      builder.taggedAddresses(json.taggedAddresses);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.check != null) {
      builder.check(json.check);
    }
    if (json.writeRequest != null) {
      builder.writeRequest(json.writeRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CatalogRegistration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CatalogRegistration instance
   */
  public static ImmutableCatalogRegistration copyOf(CatalogRegistration instance) {
    if (instance instanceof ImmutableCatalogRegistration) {
      return (ImmutableCatalogRegistration) instance;
    }
    return ImmutableCatalogRegistration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalogRegistration ImmutableCatalogRegistration}.
   * @return A new ImmutableCatalogRegistration builder
   */
  public static ImmutableCatalogRegistration.Builder builder() {
    return new ImmutableCatalogRegistration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalogRegistration ImmutableCatalogRegistration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_ADDRESS = 0x2L;
    private long initBits = 0x3;

    private Optional<String> datacenter = Optional.absent();
    private @Nullable String node;
    private @Nullable String address;
    private Optional<TaggedAddresses> taggedAddresses = Optional.absent();
    private Optional<Service> service = Optional.absent();
    private Optional<Check> check = Optional.absent();
    private Optional<WriteRequest> writeRequest = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CatalogRegistration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CatalogRegistration instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> datacenterOptional = instance.datacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      node(instance.node());
      address(instance.address());
      Optional<TaggedAddresses> taggedAddressesOptional = instance.taggedAddresses();
      if (taggedAddressesOptional.isPresent()) {
        taggedAddresses(taggedAddressesOptional);
      }
      Optional<Service> serviceOptional = instance.service();
      if (serviceOptional.isPresent()) {
        service(serviceOptional);
      }
      Optional<Check> checkOptional = instance.check();
      if (checkOptional.isPresent()) {
        check(checkOptional);
      }
      Optional<WriteRequest> writeRequestOptional = instance.writeRequest();
      if (writeRequestOptional.isPresent()) {
        writeRequest(writeRequestOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#datacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Optional.of(datacenter);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#datacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogRegistration#node() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogRegistration#address() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder address(String address) {
      this.address = Preconditions.checkNotNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#taggedAddresses() taggedAddresses} to taggedAddresses.
     * @param taggedAddresses The value for taggedAddresses
     * @return {@code this} builder for chained invocation
     */
    public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
      this.taggedAddresses = Optional.of(taggedAddresses);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#taggedAddresses() taggedAddresses} to taggedAddresses.
     * @param taggedAddresses The value for taggedAddresses
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
      this.taggedAddresses = Preconditions.checkNotNull(taggedAddresses, "taggedAddresses");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#service() service} to service.
     * @param service The value for service
     * @return {@code this} builder for chained invocation
     */
    public final Builder service(Service service) {
      this.service = Optional.of(service);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#service() service} to service.
     * @param service The value for service
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(Optional<Service> service) {
      this.service = Preconditions.checkNotNull(service, "service");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#check() check} to check.
     * @param check The value for check
     * @return {@code this} builder for chained invocation
     */
    public final Builder check(Check check) {
      this.check = Optional.of(check);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#check() check} to check.
     * @param check The value for check
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder check(Optional<Check> check) {
      this.check = Preconditions.checkNotNull(check, "check");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#writeRequest() writeRequest} to writeRequest.
     * @param writeRequest The value for writeRequest
     * @return {@code this} builder for chained invocation
     */
    public final Builder writeRequest(WriteRequest writeRequest) {
      this.writeRequest = Optional.of(writeRequest);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#writeRequest() writeRequest} to writeRequest.
     * @param writeRequest The value for writeRequest
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeRequest(Optional<WriteRequest> writeRequest) {
      this.writeRequest = Preconditions.checkNotNull(writeRequest, "writeRequest");
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalogRegistration ImmutableCatalogRegistration}.
     * @return An immutable instance of CatalogRegistration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalogRegistration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCatalogRegistration(datacenter, node, address, taggedAddresses, service, check, writeRequest);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      return "Cannot build CatalogRegistration, some of required attributes are not set " + attributes;
    }
  }
}
