/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLDocDefinition;
import com.mycila.xmltool.XMLDocumentBuilderFactory;
import com.mycila.xmltool.XMLDocumentException;
import com.mycila.xmltool.XMLTag;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLDocBuilder {
    private final XMLDocDefinition definition;

    private XMLDocBuilder(XMLDocDefinition definition) {
        this.definition = definition;
    }

    public XMLDocBuilder addNamespace(String prefix, String namespaceURI) {
        this.definition.addNamespace(prefix, namespaceURI);
        return this;
    }

    public XMLDocBuilder addDefaultNamespace(String defaultNamespaceURI) {
        this.definition.addDefaultNamespace(defaultNamespaceURI);
        return this;
    }

    public XMLTag addRoot(String tagName) {
        return XMLDocBuilder.create(this.definition.createRoot(tagName));
    }

    private static XMLTag create(final XMLDocDefinition def) {
        def.normalize();
        final XMLDoc doc = new XMLDoc(def);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Object o = method.invoke((Object)doc, args);
                    if (XMLDocBuilder.needsNormalization(method.getName())) {
                        def.normalize();
                    }
                    return o;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        };
        return (XMLTag)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{XMLTag.class}, handler);
    }

    private static boolean needsNormalization(String name) {
        return name.startsWith("add") || name.startsWith("set") || name.startsWith("delete") || name.startsWith("rename");
    }

    static XMLDocBuilder newDocument(final boolean ignoreNamespaces) {
        return XMLDocumentBuilderFactory.withDocumentBuilder(ignoreNamespaces, new XMLDocumentBuilderFactory.Callback<XMLDocBuilder>(){

            @Override
            public XMLDocBuilder apply(DocumentBuilder b) throws IOException, SAXException {
                return new XMLDocBuilder(new XMLDocDefinition(b.newDocument(), ignoreNamespaces), null);
            }
        });
    }

    static XMLTag from(File file, boolean ignoreNamespaces) {
        try {
            return XMLDocBuilder.from(new BufferedInputStream(new FileInputStream(file)), ignoreNamespaces);
        }
        catch (FileNotFoundException e) {
            throw new XMLDocumentException(e.getMessage(), e);
        }
    }

    static XMLTag from(File file, boolean ignoreNamespaces, String encoding) {
        try {
            return XMLDocBuilder.from(new BufferedInputStream(new FileInputStream(file)), ignoreNamespaces, encoding);
        }
        catch (FileNotFoundException e) {
            throw new XMLDocumentException(e.getMessage(), e);
        }
    }

    static XMLTag from(URL xmlLocation, boolean ignoreNamespaces) {
        try {
            return XMLDocBuilder.from(new BufferedInputStream(xmlLocation.openStream()), ignoreNamespaces);
        }
        catch (IOException e) {
            throw new XMLDocumentException(e.getMessage(), e);
        }
    }

    static XMLTag from(URL xmlLocation, boolean ignoreNamespaces, String encoding) {
        try {
            return XMLDocBuilder.from(new BufferedInputStream(xmlLocation.openStream()), ignoreNamespaces, encoding);
        }
        catch (IOException e) {
            throw new XMLDocumentException(e.getMessage(), e);
        }
    }

    static XMLTag from(String xmlData, boolean ignoreNamespaces) {
        return XMLDocBuilder.from(new StringReader(xmlData), ignoreNamespaces);
    }

    static XMLTag from(String xmlData, boolean ignoreNamespaces, String encoding) {
        return XMLDocBuilder.from(new StringReader(xmlData), ignoreNamespaces, encoding);
    }

    static XMLTag from(Reader reader, boolean ignoreNamespaces) {
        try {
            XMLTag xMLTag = XMLDocBuilder.from(new InputSource(reader), ignoreNamespaces);
            return xMLTag;
        }
        finally {
            XMLDocBuilder.close(reader);
        }
    }

    static XMLTag from(Reader reader, boolean ignoreNamespaces, String encoding) {
        try {
            InputSource source = new InputSource(reader);
            source.setEncoding(encoding);
            XMLTag xMLTag = XMLDocBuilder.from(source, ignoreNamespaces);
            return xMLTag;
        }
        finally {
            XMLDocBuilder.close(reader);
        }
    }

    static XMLTag from(InputStream is, boolean ignoreNamespaces) {
        try {
            XMLTag xMLTag = XMLDocBuilder.from(new InputSource(is), ignoreNamespaces);
            return xMLTag;
        }
        finally {
            XMLDocBuilder.close(is);
        }
    }

    static XMLTag from(InputStream is, boolean ignoreNamespaces, String encoding) {
        try {
            InputSource source = new InputSource(is);
            source.setEncoding(encoding);
            XMLTag xMLTag = XMLDocBuilder.from(source, ignoreNamespaces);
            return xMLTag;
        }
        finally {
            XMLDocBuilder.close(is);
        }
    }

    static XMLTag from(final InputSource source, boolean ignoreNamespaces) {
        return XMLDocBuilder.from(XMLDocumentBuilderFactory.withDocumentBuilder(ignoreNamespaces, new XMLDocumentBuilderFactory.Callback<Document>(){

            @Override
            public Document apply(DocumentBuilder b) throws IOException, SAXException {
                return b.parse(source);
            }
        }), ignoreNamespaces);
    }

    static XMLTag from(Node node, boolean ignoreNamespaces) {
        return XMLDocBuilder.create(new XMLDocDefinition(node, ignoreNamespaces));
    }

    static XMLTag from(final XMLTag tag, final boolean ignoreNamespaces) {
        return XMLDocumentBuilderFactory.withDocumentBuilder(ignoreNamespaces, new XMLDocumentBuilderFactory.Callback<XMLTag>(){

            @Override
            public XMLTag apply(DocumentBuilder b) throws IOException, SAXException {
                Document newDoc = b.newDocument();
                newDoc.appendChild(newDoc.importNode(tag.toDocument().getDocumentElement(), true));
                return XMLDocBuilder.from(newDoc, ignoreNamespaces);
            }
        });
    }

    static XMLTag fromCurrentTag(final XMLTag tag, final boolean ignoreNamespaces) {
        return XMLDocumentBuilderFactory.withDocumentBuilder(ignoreNamespaces, new XMLDocumentBuilderFactory.Callback<XMLTag>(){

            @Override
            public XMLTag apply(DocumentBuilder b) throws IOException, SAXException {
                Document newDoc = b.newDocument();
                newDoc.appendChild(newDoc.importNode(tag.getCurrentTag(), true));
                return XMLDocBuilder.from(newDoc, ignoreNamespaces);
            }
        });
    }

    static XMLTag from(Source source, boolean ignoreNamespaces) {
        DOMResult result = new DOMResult();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new XMLDocumentException("Error creating XMLDoc. Please verify that the input source can be read and is well formed", e);
        }
        return XMLDocBuilder.from(result.getNode(), ignoreNamespaces);
    }

    static XMLTag from(Source source, boolean ignoreNamespaces, String encoding) {
        DOMResult result = new DOMResult();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", encoding);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new XMLDocumentException("Error creating XMLDoc. Please verify that the input source can be read and is well formed", e);
        }
        return XMLDocBuilder.from(result.getNode(), ignoreNamespaces);
    }

    private static void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {}
    }

    /* synthetic */ XMLDocBuilder(XMLDocDefinition xMLDocDefinition, XMLDocBuilder xMLDocBuilder) {
        this(xMLDocDefinition);
    }
}

