/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class ConvertToDottedProperties
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    ConvertToDottedProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 147: 
            case 148: 
            case 154: {
                if (!NodeUtil.isValidPropertyName(CompilerOptions.LanguageMode.ECMASCRIPT3, n.getString())) break;
                n.putBooleanProp(36, false);
                this.compiler.reportCodeChange();
                break;
            }
            case 35: {
                Node left = n.getFirstChild();
                Node right = left.getNext();
                if (!right.isString() || !NodeUtil.isValidPropertyName(CompilerOptions.LanguageMode.ECMASCRIPT3, right.getString())) break;
                n.removeChild(left);
                n.removeChild(right);
                parent.replaceChild(n, IR.getprop(left, right));
                this.compiler.reportCodeChange();
            }
        }
    }
}

