/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.values.PValue;
import com.google.cloud.dataflow.sdk.values.PValueBase;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;

public abstract class TypedPValue<T>
extends PValueBase
implements PValue {
    private Coder<T> coder;
    private TypeDescriptor<T> typeDescriptor;

    public Coder<T> getCoder() {
        if (this.coder == null) {
            this.coder = this.inferCoderOrFail();
        }
        return this.coder;
    }

    public TypedPValue<T> setCoder(Coder<T> coder) {
        if (this.isFinishedSpecifyingInternal()) {
            throw new IllegalStateException("cannot change the Coder of " + this + " once it's been used");
        }
        if (coder == null) {
            throw new IllegalArgumentException("Cannot setCoder(null)");
        }
        this.coder = coder;
        return this;
    }

    @Override
    public void finishSpecifying() {
        if (this.isFinishedSpecifyingInternal()) {
            return;
        }
        super.finishSpecifying();
        this.getCoder();
    }

    protected TypedPValue(Pipeline p) {
        super(p);
    }

    public TypeDescriptor<T> getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public TypedPValue<T> setTypeDescriptorInternal(TypeDescriptor<T> typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
        return this;
    }

    private Coder<T> inferCoderOrFail() {
        CannotProvideCoderException inferFromTokenException;
        AppliedPTransform<?, ?, ?> application;
        block8: {
            if (this.coder != null) {
                return this.coder;
            }
            application = this.getProducingTransformInternal();
            CoderRegistry registry = this.getPipeline().getCoderRegistry();
            TypeDescriptor<T> token = this.getTypeDescriptor();
            inferFromTokenException = null;
            if (token != null) {
                try {
                    return registry.getDefaultCoder(token);
                }
                catch (CannotProvideCoderException exc) {
                    inferFromTokenException = exc;
                    if (!(application.getTransform() instanceof ParDo.BoundMulti) || exc.getReason() != CannotProvideCoderException.ReasonCode.TYPE_ERASURE) break block8;
                    inferFromTokenException = new CannotProvideCoderException(exc.getMessage() + " If this error occurs for a side output of the producing ParDo, verify that the " + "TupleTag for this output is constructed with proper type information (see " + "TupleTag Javadoc) or explicitly set the Coder to use if this is not possible.");
                }
            }
        }
        try {
            return ((PTransform)application.getTransform()).getDefaultOutputCoder(application.getInput(), this);
        }
        catch (CannotProvideCoderException exc) {
            CannotProvideCoderException inputCoderException = exc;
            StringBuilder messageBuilder = new StringBuilder().append("Unable to return a default Coder for ").append(this).append(". Correct one of the following root causes:");
            messageBuilder.append("\n  No Coder has been manually specified; ").append(" you may do so using .setCoder().");
            if (inferFromTokenException != null) {
                messageBuilder.append("\n  Inferring a Coder from the CoderRegistry failed: ").append(inferFromTokenException.getMessage());
            }
            if (inputCoderException != null) {
                messageBuilder.append("\n  Using the default output Coder from the producing PTransform failed: ").append(inputCoderException.getMessage());
            }
            throw new IllegalStateException(messageBuilder.toString());
        }
    }
}

