/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.values.POutputValueBase;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.Collection;
import java.util.Collections;

public abstract class PValueBase
extends POutputValueBase
implements PValue {
    private String name;
    private boolean finishedSpecifying = false;

    @Override
    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("name not set");
        }
        return this.name;
    }

    public PValueBase setName(String name) {
        if (this.finishedSpecifying) {
            throw new IllegalStateException("cannot change the name of " + this + " once it's been used");
        }
        this.name = name;
        return this;
    }

    protected PValueBase(Pipeline pipeline) {
        super(pipeline);
    }

    protected PValueBase() {
    }

    @Override
    public void recordAsOutput(AppliedPTransform<?, ?, ?> transform) {
        this.recordAsOutput(transform, "out");
    }

    protected void recordAsOutput(AppliedPTransform<?, ?, ?> transform, String outName) {
        super.recordAsOutput(transform);
        if (this.name == null) {
            this.name = transform.getFullName() + "." + outName;
        }
    }

    public boolean isFinishedSpecifyingInternal() {
        return this.finishedSpecifying;
    }

    @Override
    public Collection<? extends PValue> expand() {
        return Collections.singletonList(this);
    }

    @Override
    public void finishSpecifying() {
        this.finishSpecifyingOutput();
        this.finishedSpecifying = true;
    }

    public String toString() {
        return (this.name == null ? "<unnamed>" : this.getName()) + " [" + this.getKindString() + "]";
    }

    protected String getKindString() {
        return StringUtils.approximateSimpleName(this.getClass());
    }
}

