/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.CombineWithContext;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import com.google.cloud.dataflow.sdk.util.state.AccumulatorCombiningState;
import com.google.cloud.dataflow.sdk.util.state.BagState;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import com.google.cloud.dataflow.sdk.util.state.WatermarkHoldState;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@Experimental(value=Experimental.Kind.STATE)
public class StateTags {
    private static final CoderRegistry STANDARD_REGISTRY = new CoderRegistry();

    private StateTags() {
    }

    public static <T> StateTag<Object, ValueState<T>> value(String id, Coder<T> valueCoder) {
        return new ValueStateTag(new StructuredId(id), valueCoder);
    }

    public static <InputT, AccumT, OutputT> StateTag<Object, AccumulatorCombiningState<InputT, AccumT, OutputT>> combiningValue(String id, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return StateTags.combiningValueInternal(id, accumCoder, combineFn);
    }

    public static <K, InputT, AccumT, OutputT> StateTag<K, AccumulatorCombiningState<InputT, AccumT, OutputT>> keyedCombiningValue(String id, Coder<AccumT> accumCoder, Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> combineFn) {
        return StateTags.keyedCombiningValueInternal(id, accumCoder, combineFn);
    }

    public static <K, InputT, AccumT, OutputT> StateTag<K, AccumulatorCombiningState<InputT, AccumT, OutputT>> keyedCombiningValueWithContext(String id, Coder<AccumT> accumCoder, CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> combineFn) {
        return new KeyedCombiningValueWithContextStateTag<K, InputT, AccumT, OutputT>(new StructuredId(id), accumCoder, combineFn);
    }

    public static <InputT, AccumT, OutputT> StateTag<Object, AccumulatorCombiningState<InputT, AccumT, OutputT>> combiningValueFromInputInternal(String id, Coder<InputT> inputCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        try {
            Coder accumCoder = combineFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)inputCoder);
            return StateTags.combiningValueInternal(id, accumCoder, combineFn);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalArgumentException("Unable to determine accumulator coder for " + combineFn.getClass().getSimpleName() + " from " + inputCoder, e);
        }
    }

    private static <InputT, AccumT, OutputT> StateTag<Object, AccumulatorCombiningState<InputT, AccumT, OutputT>> combiningValueInternal(String id, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new CombiningValueStateTag(new StructuredId(id), accumCoder, combineFn);
    }

    private static <K, InputT, AccumT, OutputT> StateTag<K, AccumulatorCombiningState<InputT, AccumT, OutputT>> keyedCombiningValueInternal(String id, Coder<AccumT> accumCoder, Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> combineFn) {
        return new KeyedCombiningValueStateTag<K, InputT, AccumT, OutputT>(new StructuredId(id), accumCoder, combineFn);
    }

    public static <T> StateTag<Object, BagState<T>> bag(String id, Coder<T> elemCoder) {
        return new BagStateTag(new StructuredId(id), elemCoder);
    }

    public static <W extends BoundedWindow> StateTag<Object, WatermarkHoldState<W>> watermarkStateInternal(String id, OutputTimeFn<? super W> outputTimeFn) {
        return new WatermarkStateTagInternal(new StructuredId(id), outputTimeFn);
    }

    public static <K, StateT extends State> StateTag<K, StateT> makeSystemTagInternal(StateTag<K, StateT> tag) {
        if (!(tag instanceof SystemStateTag)) {
            throw new IllegalArgumentException("Expected subclass of StateTagBase, got " + tag);
        }
        SystemStateTag typedTag = (SystemStateTag)((Object)tag);
        return typedTag.asKind(StateKind.SYSTEM);
    }

    public static <K, InputT, AccumT, OutputT> StateTag<Object, BagState<AccumT>> convertToBagTagInternal(StateTag<? super K, AccumulatorCombiningState<InputT, AccumT, OutputT>> combiningTag) {
        if (combiningTag instanceof KeyedCombiningValueStateTag) {
            KeyedCombiningValueStateTag typedTag = (KeyedCombiningValueStateTag)combiningTag;
            return typedTag.asBagTag();
        }
        if (combiningTag instanceof KeyedCombiningValueWithContextStateTag) {
            KeyedCombiningValueWithContextStateTag typedTag = (KeyedCombiningValueWithContextStateTag)combiningTag;
            return typedTag.asBagTag();
        }
        throw new IllegalArgumentException("Unexpected StateTag " + combiningTag);
    }

    static {
        STANDARD_REGISTRY.registerStandardCoders();
    }

    private static class WatermarkStateTagInternal<W extends BoundedWindow>
    extends StateTagBase<Object, WatermarkHoldState<W>> {
        private final OutputTimeFn<? super W> outputTimeFn;

        private WatermarkStateTagInternal(StructuredId id, OutputTimeFn<? super W> outputTimeFn) {
            super(id);
            this.outputTimeFn = outputTimeFn;
        }

        @Override
        public WatermarkHoldState<W> bind(StateTag.StateBinder<? extends Object> visitor) {
            return visitor.bindWatermark(this, this.outputTimeFn);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WatermarkStateTagInternal)) {
                return false;
            }
            WatermarkStateTagInternal that = (WatermarkStateTagInternal)obj;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id);
        }

        @Override
        public StateTag<Object, WatermarkHoldState<W>> asKind(StateKind kind) {
            return new WatermarkStateTagInternal<W>(this.id.asKind(kind), this.outputTimeFn);
        }
    }

    private static class BagStateTag<T>
    extends StateTagBase<Object, BagState<T>>
    implements StateTag<Object, BagState<T>> {
        private final Coder<T> elemCoder;

        private BagStateTag(StructuredId id, Coder<T> elemCoder) {
            super(id);
            this.elemCoder = elemCoder;
        }

        @Override
        public BagState<T> bind(StateTag.StateBinder<? extends Object> visitor) {
            return visitor.bindBag(this, this.elemCoder);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BagStateTag)) {
                return false;
            }
            BagStateTag that = (BagStateTag)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.elemCoder, that.elemCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id, this.elemCoder);
        }

        @Override
        public StateTag<Object, BagState<T>> asKind(StateKind kind) {
            return new BagStateTag<T>(this.id.asKind(kind), this.elemCoder);
        }
    }

    private static class KeyedCombiningValueStateTag<K, InputT, AccumT, OutputT>
    extends StateTagBase<K, AccumulatorCombiningState<InputT, AccumT, OutputT>>
    implements SystemStateTag<K, AccumulatorCombiningState<InputT, AccumT, OutputT>> {
        private final Coder<AccumT> accumCoder;
        private final Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> keyedCombineFn;

        protected KeyedCombiningValueStateTag(StructuredId id, Coder<AccumT> accumCoder, Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> keyedCombineFn) {
            super(id);
            this.keyedCombineFn = keyedCombineFn;
            this.accumCoder = accumCoder;
        }

        @Override
        public AccumulatorCombiningState<InputT, AccumT, OutputT> bind(StateTag.StateBinder<? extends K> visitor) {
            return visitor.bindKeyedCombiningValue(this, this.accumCoder, this.keyedCombineFn);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CombiningValueStateTag)) {
                return false;
            }
            KeyedCombiningValueStateTag that = (KeyedCombiningValueStateTag)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.accumCoder, that.accumCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id, this.accumCoder);
        }

        @Override
        public StateTag<K, AccumulatorCombiningState<InputT, AccumT, OutputT>> asKind(StateKind kind) {
            return new KeyedCombiningValueStateTag<K, InputT, AccumT, OutputT>(this.id.asKind(kind), this.accumCoder, this.keyedCombineFn);
        }

        private StateTag<Object, BagState<AccumT>> asBagTag() {
            return new BagStateTag(this.id, this.accumCoder);
        }
    }

    private static class KeyedCombiningValueWithContextStateTag<K, InputT, AccumT, OutputT>
    extends StateTagBase<K, AccumulatorCombiningState<InputT, AccumT, OutputT>>
    implements SystemStateTag<K, AccumulatorCombiningState<InputT, AccumT, OutputT>> {
        private final Coder<AccumT> accumCoder;
        private final CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> combineFn;

        protected KeyedCombiningValueWithContextStateTag(StructuredId id, Coder<AccumT> accumCoder, CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> combineFn) {
            super(id);
            this.combineFn = combineFn;
            this.accumCoder = accumCoder;
        }

        @Override
        public AccumulatorCombiningState<InputT, AccumT, OutputT> bind(StateTag.StateBinder<? extends K> visitor) {
            return visitor.bindKeyedCombiningValueWithContext(this, this.accumCoder, this.combineFn);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof KeyedCombiningValueWithContextStateTag)) {
                return false;
            }
            KeyedCombiningValueWithContextStateTag that = (KeyedCombiningValueWithContextStateTag)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.accumCoder, that.accumCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id, this.accumCoder);
        }

        @Override
        public StateTag<K, AccumulatorCombiningState<InputT, AccumT, OutputT>> asKind(StateKind kind) {
            return new KeyedCombiningValueWithContextStateTag<K, InputT, AccumT, OutputT>(this.id.asKind(kind), this.accumCoder, this.combineFn);
        }

        private StateTag<Object, BagState<AccumT>> asBagTag() {
            return new BagStateTag(this.id, this.accumCoder);
        }
    }

    private static class CombiningValueStateTag<InputT, AccumT, OutputT>
    extends KeyedCombiningValueStateTag<Object, InputT, AccumT, OutputT>
    implements StateTag<Object, AccumulatorCombiningState<InputT, AccumT, OutputT>>,
    SystemStateTag<Object, AccumulatorCombiningState<InputT, AccumT, OutputT>> {
        private final Coder<AccumT> accumCoder;
        private final Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        private CombiningValueStateTag(StructuredId id, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            super(id, accumCoder, combineFn.asKeyedFn());
            this.combineFn = combineFn;
            this.accumCoder = accumCoder;
        }

        @Override
        public StateTag<Object, AccumulatorCombiningState<InputT, AccumT, OutputT>> asKind(StateKind kind) {
            return new CombiningValueStateTag<InputT, AccumT, OutputT>(this.id.asKind(kind), this.accumCoder, this.combineFn);
        }
    }

    private static class ValueStateTag<T>
    extends StateTagBase<Object, ValueState<T>>
    implements StateTag<Object, ValueState<T>> {
        private final Coder<T> coder;

        private ValueStateTag(StructuredId id, Coder<T> coder) {
            super(id);
            this.coder = coder;
        }

        @Override
        public ValueState<T> bind(StateTag.StateBinder<? extends Object> visitor) {
            return visitor.bindValue(this, this.coder);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ValueStateTag)) {
                return false;
            }
            ValueStateTag that = (ValueStateTag)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.coder, that.coder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id, this.coder);
        }

        @Override
        public StateTag<Object, ValueState<T>> asKind(StateKind kind) {
            return new ValueStateTag<T>(this.id.asKind(kind), this.coder);
        }
    }

    private static abstract class StateTagBase<K, StateT extends State>
    implements StateTag<K, StateT>,
    SystemStateTag<K, StateT> {
        protected final StructuredId id;

        protected StateTagBase(StructuredId id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id.getRawId();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", this.id).toString();
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            this.id.appendTo(sb);
        }

        @Override
        public abstract StateTag<K, StateT> asKind(StateKind var1);
    }

    private static class StructuredId
    implements Serializable {
        private final StateKind kind;
        private final String rawId;

        private StructuredId(String rawId) {
            this(StateKind.USER, rawId);
        }

        private StructuredId(StateKind kind, String rawId) {
            this.kind = kind;
            this.rawId = rawId;
        }

        public StructuredId asKind(StateKind kind) {
            return new StructuredId(kind, this.rawId);
        }

        public void appendTo(Appendable sb) throws IOException {
            sb.append(this.kind.prefix).append(this.rawId);
        }

        public String getRawId() {
            return this.rawId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", this.rawId).add("kind", (Object)this.kind).toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StructuredId)) {
                return false;
            }
            StructuredId that = (StructuredId)obj;
            return Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.rawId, that.rawId);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.rawId});
        }
    }

    private static interface SystemStateTag<K, StateT extends State> {
        public StateTag<K, StateT> asKind(StateKind var1);
    }

    private static enum StateKind {
        SYSTEM('s'),
        USER('u');

        private char prefix;

        private StateKind(char prefix) {
            this.prefix = prefix;
        }
    }
}

