/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common;

import com.google.cloud.dataflow.sdk.util.common.Counter;
import java.util.Observable;
import java.util.Observer;

public class ElementByteSizeObserver
implements Observer {
    private final Counter<Long> counter;
    private boolean isLazy = false;
    private long totalSize = 0L;
    private double scalingFactor = 1.0;

    public ElementByteSizeObserver(Counter<Long> counter) {
        this.counter = counter;
    }

    public void setLazy() {
        this.isLazy = true;
    }

    public boolean getIsLazy() {
        return this.isLazy;
    }

    public void update(Object obj) {
        this.update(null, obj);
    }

    public void setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obj instanceof Long) {
            this.totalSize = (long)((double)this.totalSize + this.scalingFactor * (double)((Long)obj).longValue());
        } else if (obj instanceof Integer) {
            this.totalSize = (long)((double)this.totalSize + this.scalingFactor * (double)((Integer)obj).intValue());
        } else {
            throw new AssertionError((Object)"unexpected parameter object");
        }
    }

    public void advance() {
        this.counter.addValue(this.totalSize);
        this.totalSize = 0L;
        this.isLazy = false;
    }
}

