/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.NameContext;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class CounterSet
extends AbstractSet<Counter<?>> {
    private final ConcurrentHashMap<Counter.Name, Counter<?>> counters = new ConcurrentHashMap();
    private final AddCounterMutator addCounterMutator = new AddCounterMutator();

    public CounterSet(Counter<?> ... counters) {
        for (Counter<?> counter : counters) {
            this.addNewCounter(counter);
        }
    }

    public AddCounterMutator getAddCounterMutator() {
        return this.addCounterMutator;
    }

    public AddCounterMutator getAddCounterMutator(NameContext context) {
        AddCounterMutator addCounterWithContextMutator = new AddCounterMutator(context);
        return addCounterWithContextMutator;
    }

    public void addNewCounter(Counter<?> counter) {
        if (!this.addCounter(counter)) {
            throw new IllegalArgumentException("Counter " + counter + " duplicates an existing counter in " + this);
        }
    }

    public <T> Counter<T> addOrReuseCounter(Counter<T> counter) {
        Counter<T> oldCounter = this.counters.putIfAbsent(counter.getUniqueName(), counter);
        if (oldCounter != null) {
            Preconditions.checkArgument(counter.isCompatibleWith(oldCounter), "Counter %s duplicates incompatible counter %s in %s", counter, oldCounter, this);
            Counter<T> compatibleCounter = oldCounter;
            return compatibleCounter;
        }
        return counter;
    }

    public boolean addCounter(Counter<?> counter) {
        return this.add(counter);
    }

    public synchronized Counter<?> getExistingCounter(Counter.Name name) {
        return this.counters.get(name);
    }

    public Counter<?> getExistingCounter(String name) {
        Counter.Name unstructuredName = Counter.Name.withoutStructure(name);
        return this.counters.get(unstructuredName);
    }

    @Override
    public Iterator<Counter<?>> iterator() {
        return this.counters.values().iterator();
    }

    @Override
    public int size() {
        return this.counters.size();
    }

    @Override
    public boolean add(Counter<?> e) {
        if (null == e) {
            return false;
        }
        return this.counters.putIfAbsent(e.getUniqueName(), e) == null;
    }

    public void merge(CounterSet that) {
        for (Counter<?> theirCounter : that) {
            Counter<?> myCounter = this.counters.get(theirCounter.getUniqueName());
            if (myCounter != null) {
                this.mergeCounters(myCounter, theirCounter);
                continue;
            }
            this.addCounter(theirCounter);
        }
    }

    private <T> void mergeCounters(Counter<T> mine, Counter<?> theirCounter) {
        Preconditions.checkArgument(mine.isCompatibleWith(theirCounter), "Can't merge CounterSets containing incompatible counters with the same name: %s (existing) and %s (merged)", mine, theirCounter);
        Counter<?> theirs = theirCounter;
        mine.merge(theirs);
    }

    public class AddCounterMutator {
        private final NameContext context;

        public AddCounterMutator(NameContext context) {
            this.context = Preconditions.checkNotNull(context);
        }

        public AddCounterMutator() {
            this.context = null;
        }

        public <T> Counter<T> addCounter(Counter<T> counter) {
            return CounterSet.this.addOrReuseCounter(counter);
        }

        public NameContext getNameContext() {
            return this.context;
        }
    }
}

