/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.DefaultTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.BitSetCoder;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.FinishedTriggersBitSet;
import com.google.cloud.dataflow.sdk.util.Timers;
import com.google.cloud.dataflow.sdk.util.TriggerContextFactory;
import com.google.cloud.dataflow.sdk.util.state.MergingStateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import org.joda.time.Instant;

public class TriggerRunner<W extends BoundedWindow> {
    @VisibleForTesting
    static final StateTag<Object, ValueState<BitSet>> FINISHED_BITS_TAG = StateTags.makeSystemTagInternal(StateTags.value("closed", BitSetCoder.of()));
    private final ExecutableTrigger<W> rootTrigger;
    private final TriggerContextFactory<W> contextFactory;

    public TriggerRunner(ExecutableTrigger<W> rootTrigger, TriggerContextFactory<W> contextFactory) {
        Preconditions.checkState(rootTrigger.getTriggerIndex() == 0);
        this.rootTrigger = rootTrigger;
        this.contextFactory = contextFactory;
    }

    private FinishedTriggersBitSet readFinishedBits(ValueState<BitSet> state) {
        if (!this.isFinishedSetNeeded()) {
            return FinishedTriggersBitSet.emptyWithCapacity(this.rootTrigger.getFirstIndexAfterSubtree());
        }
        BitSet bitSet = (BitSet)state.read();
        return bitSet == null ? FinishedTriggersBitSet.emptyWithCapacity(this.rootTrigger.getFirstIndexAfterSubtree()) : FinishedTriggersBitSet.fromBitSet(bitSet);
    }

    private void clearFinishedBits(ValueState<BitSet> state) {
        if (!this.isFinishedSetNeeded()) {
            return;
        }
        state.clear();
    }

    public boolean isClosed(StateAccessor<?> state) {
        return this.readFinishedBits(state.access(FINISHED_BITS_TAG)).isFinished(this.rootTrigger);
    }

    public void prefetchForValue(W window, StateAccessor<?> state) {
        if (this.isFinishedSetNeeded()) {
            state.access(FINISHED_BITS_TAG).readLater();
        }
        this.rootTrigger.getSpec().prefetchOnElement(this.contextFactory.createStateAccessor(window, this.rootTrigger));
    }

    public void prefetchOnFire(W window, StateAccessor<?> state) {
        if (this.isFinishedSetNeeded()) {
            state.access(FINISHED_BITS_TAG).readLater();
        }
        this.rootTrigger.getSpec().prefetchOnFire(this.contextFactory.createStateAccessor(window, this.rootTrigger));
    }

    public void prefetchShouldFire(W window, StateAccessor<?> state) {
        if (this.isFinishedSetNeeded()) {
            state.access(FINISHED_BITS_TAG).readLater();
        }
        this.rootTrigger.getSpec().prefetchShouldFire(this.contextFactory.createStateAccessor(window, this.rootTrigger));
    }

    public void processValue(W window, Instant timestamp, Timers timers, StateAccessor<?> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        Trigger.OnElementContext triggerContext = this.contextFactory.createOnElementContext(window, timers, timestamp, this.rootTrigger, finishedSet);
        this.rootTrigger.invokeOnElement(triggerContext);
        this.persistFinishedSet(state, finishedSet);
    }

    public void prefetchForMerge(W window, Collection<W> mergingWindows, MergingStateAccessor<?, W> state) {
        if (this.isFinishedSetNeeded()) {
            for (ValueState<BitSet> value : state.accessInEachMergingWindow(FINISHED_BITS_TAG).values()) {
                value.readLater();
            }
        }
        this.rootTrigger.getSpec().prefetchOnMerge(this.contextFactory.createMergingStateAccessor(window, mergingWindows, this.rootTrigger));
    }

    public void onMerge(W window, Timers timers, MergingStateAccessor<?, W> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        ImmutableMap.Builder<W, FinishedTriggersBitSet> builder = ImmutableMap.builder();
        for (Map.Entry<W, ValueState<BitSet>> entry : state.accessInEachMergingWindow(FINISHED_BITS_TAG).entrySet()) {
            builder.put(entry.getKey(), this.readFinishedBits(entry.getValue()));
            this.clearFinishedBits(entry.getValue());
        }
        ImmutableMap mergingFinishedSets = builder.build();
        Trigger.OnMergeContext mergeContext = this.contextFactory.createOnMergeContext(window, timers, this.rootTrigger, finishedSet, mergingFinishedSets);
        this.rootTrigger.invokeOnMerge(mergeContext);
        this.persistFinishedSet(state, finishedSet);
    }

    public boolean shouldFire(W window, Timers timers, StateAccessor<?> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        Trigger.TriggerContext context = this.contextFactory.base(window, timers, this.rootTrigger, finishedSet);
        return this.rootTrigger.invokeShouldFire(context);
    }

    public void onFire(W window, Timers timers, StateAccessor<?> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        Trigger.TriggerContext context = this.contextFactory.base(window, timers, this.rootTrigger, finishedSet);
        this.rootTrigger.invokeOnFire(context);
        this.persistFinishedSet(state, finishedSet);
    }

    private void persistFinishedSet(StateAccessor<?> state, FinishedTriggersBitSet modifiedFinishedSet) {
        if (!this.isFinishedSetNeeded()) {
            return;
        }
        ValueState<BitSet> finishedSetState = state.access(FINISHED_BITS_TAG);
        if (!this.readFinishedBits(finishedSetState).equals(modifiedFinishedSet)) {
            if (modifiedFinishedSet.getBitSet().isEmpty()) {
                finishedSetState.clear();
            } else {
                finishedSetState.write(modifiedFinishedSet.getBitSet());
            }
        }
    }

    public void clearFinished(StateAccessor<?> state) {
        this.clearFinishedBits(state.access(FINISHED_BITS_TAG));
    }

    public void clearState(W window, Timers timers, StateAccessor<?> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG));
        this.rootTrigger.invokeClear(this.contextFactory.base(window, timers, this.rootTrigger, finishedSet));
    }

    private boolean isFinishedSetNeeded() {
        return !(this.rootTrigger.getSpec() instanceof DefaultTrigger);
    }
}

