/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.ByteStreams;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.primitives.UnsignedBytes;
import com.google.cloud.dataflow.sdk.util.VarInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RandomAccessData {
    public static final UnsignedLexicographicalComparator UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = new UnsignedLexicographicalComparator();
    static final RandomAccessData POSITIVE_INFINITY = new RandomAccessData(0);
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    private byte[] buffer;
    private int size;
    private final OutputStream outputStream = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            RandomAccessData.this.ensureCapacity(RandomAccessData.this.size + 1);
            ((RandomAccessData)RandomAccessData.this).buffer[((RandomAccessData)RandomAccessData.this).size] = (byte)b;
            RandomAccessData.this.size = RandomAccessData.this.size + 1;
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            RandomAccessData.this.ensureCapacity(RandomAccessData.this.size + length);
            System.arraycopy(b, offset, RandomAccessData.this.buffer, RandomAccessData.this.size, length);
            RandomAccessData.this.size = RandomAccessData.this.size + length;
        }
    };

    public RandomAccessData increment() throws IOException {
        RandomAccessData copy = this.copy();
        for (int i = copy.size - 1; i >= 0; --i) {
            if (copy.buffer[i] == -1) continue;
            copy.buffer[i] = UnsignedBytes.checkedCast(UnsignedBytes.toInt(copy.buffer[i]) + 1);
            return copy;
        }
        return POSITIVE_INFINITY;
    }

    public RandomAccessData() {
        this(128);
    }

    public RandomAccessData(byte[] initialBuffer) {
        Preconditions.checkNotNull(initialBuffer);
        this.buffer = initialBuffer;
        this.size = initialBuffer.length;
    }

    public RandomAccessData(int initialBufferSize) {
        Preconditions.checkArgument(initialBufferSize >= 0, "Expected initial buffer size to be greater than zero.");
        this.buffer = new byte[initialBufferSize];
    }

    public byte[] array() {
        return this.buffer;
    }

    public int size() {
        return this.size;
    }

    public void resetTo(int position) {
        this.ensureCapacity(position);
        this.size = position;
    }

    public OutputStream asOutputStream() {
        return this.outputStream;
    }

    public InputStream asInputStream(int offset, int length) {
        return new ByteArrayInputStream(this.buffer, offset, length);
    }

    public void writeTo(OutputStream out, int offset, int length) throws IOException {
        out.write(this.buffer, offset, length);
    }

    public void readFrom(InputStream inStream, int offset, int length) throws IOException {
        this.ensureCapacity(offset + length);
        ByteStreams.readFully(inStream, this.buffer, offset, length);
        this.size = offset + length;
    }

    public RandomAccessData copy() throws IOException {
        RandomAccessData copy = new RandomAccessData(this.size);
        this.writeTo(copy.asOutputStream(), 0, this.size);
        return copy;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RandomAccessData)) {
            return false;
        }
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(this, (RandomAccessData)other) == 0;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.buffer[i];
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("buffer", Arrays.copyOf(this.buffer, this.size)).add("size", this.size).toString();
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.buffer.length) {
            return;
        }
        int newCapacity = (int)Math.min(Integer.MAX_VALUE, (long)this.buffer.length * 2L);
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    public static final class UnsignedLexicographicalComparator
    implements Comparator<RandomAccessData> {
        private UnsignedLexicographicalComparator() {
        }

        @Override
        public int compare(RandomAccessData o1, RandomAccessData o2) {
            return this.compare(o1, o2, 0);
        }

        public int compare(RandomAccessData o1, RandomAccessData o2, int startOffset) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == POSITIVE_INFINITY) {
                return 1;
            }
            if (o2 == POSITIVE_INFINITY) {
                return -1;
            }
            int minBytesLen = Math.min(o1.size, o2.size);
            for (int i = startOffset; i < minBytesLen; ++i) {
                int b2;
                int b1 = o1.buffer[i] & 0xFF;
                if (b1 == (b2 = o2.buffer[i] & 0xFF)) continue;
                return b1 - b2;
            }
            return o1.size - o2.size;
        }

        public int commonPrefixLength(RandomAccessData o1, RandomAccessData o2) {
            int minBytesLen = Math.min(o1.size, o2.size);
            for (int i = 0; i < minBytesLen; ++i) {
                int b2;
                int b1 = o1.buffer[i] & 0xFF;
                if (b1 == (b2 = o2.buffer[i] & 0xFF)) continue;
                return i;
            }
            return minBytesLen;
        }
    }

    public static class RandomAccessDataCoder
    extends AtomicCoder<RandomAccessData> {
        private static final RandomAccessDataCoder INSTANCE = new RandomAccessDataCoder();

        @JsonCreator
        public static RandomAccessDataCoder of() {
            return INSTANCE;
        }

        @Override
        public void encode(RandomAccessData value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            if (value == POSITIVE_INFINITY) {
                throw new CoderException("Positive infinity can not be encoded.");
            }
            if (!context.isWholeStream) {
                VarInt.encode(value.size, outStream);
            }
            value.writeTo(outStream, 0, value.size);
        }

        @Override
        public RandomAccessData decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            RandomAccessData rval = new RandomAccessData();
            if (!context.isWholeStream) {
                int length = VarInt.decodeInt(inStream);
                rval.readFrom(inStream, 0, length);
            } else {
                ByteStreams.copy(inStream, rval.asOutputStream());
            }
            return rval;
        }

        @Override
        public boolean consistentWithEquals() {
            return true;
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(RandomAccessData value, Coder.Context context) {
            return true;
        }

        @Override
        protected long getEncodedElementByteSize(RandomAccessData value, Coder.Context context) throws Exception {
            if (value == null) {
                throw new CoderException("cannot encode a null in memory stream");
            }
            long size = 0L;
            if (!context.isWholeStream) {
                size += (long)VarInt.getLength(value.size);
            }
            return size + (long)value.size;
        }
    }
}

