/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.ListSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicsResponse;
import com.google.api.services.pubsub.model.ModifyAckDeadlineRequest;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PublishResponse;
import com.google.api.services.pubsub.model.PubsubMessage;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.ReceivedMessage;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.Topic;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Strings;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.util.PubsubClient;
import com.google.cloud.dataflow.sdk.util.RetryHttpRequestInitializer;
import com.google.cloud.dataflow.sdk.util.Transport;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class PubsubJsonClient
extends PubsubClient {
    public static final PubsubClient.PubsubClientFactory FACTORY = new PubsubJsonClientFactory();
    @Nullable
    private final String timestampLabel;
    @Nullable
    private final String idLabel;
    private Pubsub pubsub;

    @VisibleForTesting
    PubsubJsonClient(@Nullable String timestampLabel, @Nullable String idLabel, Pubsub pubsub) {
        this.timestampLabel = timestampLabel;
        this.idLabel = idLabel;
        this.pubsub = pubsub;
    }

    @Override
    public void close() {
    }

    @Override
    public int publish(PubsubClient.TopicPath topic, List<PubsubClient.OutgoingMessage> outgoingMessages) throws IOException {
        ArrayList<PubsubMessage> pubsubMessages = new ArrayList<PubsubMessage>(outgoingMessages.size());
        for (PubsubClient.OutgoingMessage outgoingMessage : outgoingMessages) {
            PubsubMessage pubsubMessage = new PubsubMessage().encodeData(outgoingMessage.elementBytes);
            TreeMap<String, String> attributes = pubsubMessage.getAttributes();
            if ((this.timestampLabel != null || this.idLabel != null) && attributes == null) {
                attributes = new TreeMap<String, String>();
                pubsubMessage.setAttributes(attributes);
            }
            if (this.timestampLabel != null) {
                attributes.put(this.timestampLabel, String.valueOf(outgoingMessage.timestampMsSinceEpoch));
            }
            if (this.idLabel != null && !Strings.isNullOrEmpty(outgoingMessage.recordId)) {
                attributes.put(this.idLabel, outgoingMessage.recordId);
            }
            pubsubMessages.add(pubsubMessage);
        }
        PublishRequest request = new PublishRequest().setMessages(pubsubMessages);
        PublishResponse response = (PublishResponse)this.pubsub.projects().topics().publish(topic.getPath(), request).execute();
        return response.getMessageIds().size();
    }

    @Override
    public List<PubsubClient.IncomingMessage> pull(long requestTimeMsSinceEpoch, PubsubClient.SubscriptionPath subscription, int batchSize, boolean returnImmediately) throws IOException {
        PullRequest request = new PullRequest().setReturnImmediately(Boolean.valueOf(returnImmediately)).setMaxMessages(Integer.valueOf(batchSize));
        PullResponse response = (PullResponse)this.pubsub.projects().subscriptions().pull(subscription.getPath(), request).execute();
        if (response.getReceivedMessages() == null || response.getReceivedMessages().size() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.IncomingMessage> incomingMessages = new ArrayList<PubsubClient.IncomingMessage>(response.getReceivedMessages().size());
        for (ReceivedMessage message : response.getReceivedMessages()) {
            PubsubMessage pubsubMessage = message.getMessage();
            Map attributes = pubsubMessage.getAttributes();
            byte[] elementBytes = pubsubMessage.decodeData();
            long timestampMsSinceEpoch = PubsubJsonClient.extractTimestamp(this.timestampLabel, message.getMessage().getPublishTime(), attributes);
            String ackId = message.getAckId();
            Preconditions.checkState(!Strings.isNullOrEmpty(ackId));
            String recordId = null;
            if (this.idLabel != null && attributes != null) {
                recordId = (String)attributes.get(this.idLabel);
            }
            if (Strings.isNullOrEmpty(recordId)) {
                recordId = pubsubMessage.getMessageId();
            }
            incomingMessages.add(new PubsubClient.IncomingMessage(elementBytes, timestampMsSinceEpoch, requestTimeMsSinceEpoch, ackId, recordId));
        }
        return incomingMessages;
    }

    @Override
    public void acknowledge(PubsubClient.SubscriptionPath subscription, List<String> ackIds) throws IOException {
        AcknowledgeRequest request = new AcknowledgeRequest().setAckIds(ackIds);
        this.pubsub.projects().subscriptions().acknowledge(subscription.getPath(), request).execute();
    }

    @Override
    public void modifyAckDeadline(PubsubClient.SubscriptionPath subscription, List<String> ackIds, int deadlineSeconds) throws IOException {
        ModifyAckDeadlineRequest request = new ModifyAckDeadlineRequest().setAckIds(ackIds).setAckDeadlineSeconds(Integer.valueOf(deadlineSeconds));
        this.pubsub.projects().subscriptions().modifyAckDeadline(subscription.getPath(), request).execute();
    }

    @Override
    public void createTopic(PubsubClient.TopicPath topic) throws IOException {
        this.pubsub.projects().topics().create(topic.getPath(), new Topic()).execute();
    }

    @Override
    public void deleteTopic(PubsubClient.TopicPath topic) throws IOException {
        this.pubsub.projects().topics().delete(topic.getPath()).execute();
    }

    @Override
    public List<PubsubClient.TopicPath> listTopics(PubsubClient.ProjectPath project) throws IOException {
        ListTopicsResponse response = (ListTopicsResponse)this.pubsub.projects().topics().list(project.getPath()).execute();
        if (response.getTopics() == null || response.getTopics().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.TopicPath> topics = new ArrayList<PubsubClient.TopicPath>(response.getTopics().size());
        for (Topic topic : response.getTopics()) {
            topics.add(PubsubJsonClient.topicPathFromPath(topic.getName()));
        }
        return topics;
    }

    @Override
    public void createSubscription(PubsubClient.TopicPath topic, PubsubClient.SubscriptionPath subscription, int ackDeadlineSeconds) throws IOException {
        Subscription request = new Subscription().setTopic(topic.getPath()).setAckDeadlineSeconds(Integer.valueOf(ackDeadlineSeconds));
        this.pubsub.projects().subscriptions().create(subscription.getPath(), request).execute();
    }

    @Override
    public void deleteSubscription(PubsubClient.SubscriptionPath subscription) throws IOException {
        this.pubsub.projects().subscriptions().delete(subscription.getPath()).execute();
    }

    @Override
    public List<PubsubClient.SubscriptionPath> listSubscriptions(PubsubClient.ProjectPath project, PubsubClient.TopicPath topic) throws IOException {
        ListSubscriptionsResponse response = (ListSubscriptionsResponse)this.pubsub.projects().subscriptions().list(project.getPath()).execute();
        if (response.getSubscriptions() == null || response.getSubscriptions().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.SubscriptionPath> subscriptions = new ArrayList<PubsubClient.SubscriptionPath>(response.getSubscriptions().size());
        for (Subscription subscription : response.getSubscriptions()) {
            if (!subscription.getTopic().equals(topic.getPath())) continue;
            subscriptions.add(PubsubJsonClient.subscriptionPathFromPath(subscription.getName()));
        }
        return subscriptions;
    }

    @Override
    public int ackDeadlineSeconds(PubsubClient.SubscriptionPath subscription) throws IOException {
        Subscription response = (Subscription)this.pubsub.projects().subscriptions().get(subscription.getPath()).execute();
        return response.getAckDeadlineSeconds();
    }

    @Override
    public boolean isEOF() {
        return false;
    }

    private static class PubsubJsonClientFactory
    implements PubsubClient.PubsubClientFactory {
        private PubsubJsonClientFactory() {
        }

        private static HttpRequestInitializer chainHttpRequestInitializer(Credential credential, HttpRequestInitializer httpRequestInitializer) {
            if (credential == null) {
                return httpRequestInitializer;
            }
            return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{credential, httpRequestInitializer});
        }

        @Override
        public PubsubClient newClient(@Nullable String timestampLabel, @Nullable String idLabel, DataflowPipelineOptions options) throws IOException {
            Pubsub pubsub = new Pubsub.Builder(Transport.getTransport(), Transport.getJsonFactory(), PubsubJsonClientFactory.chainHttpRequestInitializer(options.getGcpCredential(), new RetryHttpRequestInitializer(ImmutableList.of(Integer.valueOf(404))))).setRootUrl(options.getPubsubRootUrl()).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace()).build();
            return new PubsubJsonClient(timestampLabel, idLabel, pubsub);
        }

        @Override
        public String getKind() {
            return "Json";
        }
    }
}

