/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.util.DateTime;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public abstract class PubsubClient
implements Closeable {
    @Nullable
    private static Long asMsSinceEpoch(@Nullable String timestamp) {
        if (Strings.isNullOrEmpty(timestamp)) {
            return null;
        }
        try {
            return Long.parseLong(timestamp);
        }
        catch (IllegalArgumentException e1) {
            return DateTime.parseRfc3339((String)timestamp).getValue();
        }
    }

    protected static long extractTimestamp(@Nullable String timestampLabel, @Nullable String pubsubTimestamp, @Nullable Map<String, String> attributes) {
        Long timestampMsSinceEpoch;
        if (Strings.isNullOrEmpty(timestampLabel)) {
            timestampMsSinceEpoch = PubsubClient.asMsSinceEpoch(pubsubTimestamp);
            Preconditions.checkArgument(timestampMsSinceEpoch != null, "Cannot interpret PubSub publish timestamp: %s", pubsubTimestamp);
        } else {
            String value = attributes == null ? null : attributes.get(timestampLabel);
            Preconditions.checkArgument(value != null, "PubSub message is missing a value for timestamp label %s", timestampLabel);
            timestampMsSinceEpoch = PubsubClient.asMsSinceEpoch(value);
            Preconditions.checkArgument(timestampMsSinceEpoch != null, "Cannot interpret value of label %s as timestamp: %s", timestampLabel, value);
        }
        return timestampMsSinceEpoch;
    }

    public static ProjectPath projectPathFromPath(String path) {
        return new ProjectPath(path);
    }

    public static ProjectPath projectPathFromId(String projectId) {
        return new ProjectPath(String.format("projects/%s", projectId));
    }

    public static SubscriptionPath subscriptionPathFromPath(String path) {
        return new SubscriptionPath(path);
    }

    public static SubscriptionPath subscriptionPathFromName(String projectId, String subscriptionName) {
        return new SubscriptionPath(String.format("projects/%s/subscriptions/%s", projectId, subscriptionName));
    }

    public static TopicPath topicPathFromPath(String path) {
        return new TopicPath(path);
    }

    public static TopicPath topicPathFromName(String projectId, String topicName) {
        return new TopicPath(String.format("projects/%s/topics/%s", projectId, topicName));
    }

    public abstract int publish(TopicPath var1, List<OutgoingMessage> var2) throws IOException;

    public abstract List<IncomingMessage> pull(long var1, SubscriptionPath var3, int var4, boolean var5) throws IOException;

    public abstract void acknowledge(SubscriptionPath var1, List<String> var2) throws IOException;

    public abstract void modifyAckDeadline(SubscriptionPath var1, List<String> var2, int var3) throws IOException;

    public abstract void createTopic(TopicPath var1) throws IOException;

    public abstract void deleteTopic(TopicPath var1) throws IOException;

    public abstract List<TopicPath> listTopics(ProjectPath var1) throws IOException;

    public abstract void createSubscription(TopicPath var1, SubscriptionPath var2, int var3) throws IOException;

    public SubscriptionPath createRandomSubscription(ProjectPath project, TopicPath topic, int ackDeadlineSeconds) throws IOException {
        String subscriptionName = topic.getName() + "_beam_" + ThreadLocalRandom.current().nextLong();
        SubscriptionPath subscription = PubsubClient.subscriptionPathFromName(project.getId(), subscriptionName);
        this.createSubscription(topic, subscription, ackDeadlineSeconds);
        return subscription;
    }

    public abstract void deleteSubscription(SubscriptionPath var1) throws IOException;

    public abstract List<SubscriptionPath> listSubscriptions(ProjectPath var1, TopicPath var2) throws IOException;

    public abstract int ackDeadlineSeconds(SubscriptionPath var1) throws IOException;

    public abstract boolean isEOF();

    public static class IncomingMessage
    implements Serializable {
        public final byte[] elementBytes;
        public final long timestampMsSinceEpoch;
        public final long requestTimeMsSinceEpoch;
        public final String ackId;
        public final String recordId;

        public IncomingMessage(byte[] elementBytes, long timestampMsSinceEpoch, long requestTimeMsSinceEpoch, String ackId, String recordId) {
            this.elementBytes = elementBytes;
            this.timestampMsSinceEpoch = timestampMsSinceEpoch;
            this.requestTimeMsSinceEpoch = requestTimeMsSinceEpoch;
            this.ackId = ackId;
            this.recordId = recordId;
        }

        public IncomingMessage withRequestTime(long requestTimeMsSinceEpoch) {
            return new IncomingMessage(this.elementBytes, this.timestampMsSinceEpoch, requestTimeMsSinceEpoch, this.ackId, this.recordId);
        }

        public String toString() {
            return String.format("IncomingMessage(%db, %dms)", this.elementBytes.length, this.timestampMsSinceEpoch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncomingMessage that = (IncomingMessage)o;
            return this.timestampMsSinceEpoch == that.timestampMsSinceEpoch && this.requestTimeMsSinceEpoch == that.requestTimeMsSinceEpoch && this.ackId.equals(that.ackId) && this.recordId.equals(that.recordId) && Arrays.equals(this.elementBytes, that.elementBytes);
        }

        public int hashCode() {
            return Objects.hashCode(Arrays.hashCode(this.elementBytes), this.timestampMsSinceEpoch, this.requestTimeMsSinceEpoch, this.ackId, this.recordId);
        }
    }

    public static class OutgoingMessage
    implements Serializable {
        public final byte[] elementBytes;
        public final long timestampMsSinceEpoch;
        @Nullable
        public final String recordId;

        public OutgoingMessage(byte[] elementBytes, long timestampMsSinceEpoch, @Nullable String recordId) {
            this.elementBytes = elementBytes;
            this.timestampMsSinceEpoch = timestampMsSinceEpoch;
            this.recordId = recordId;
        }

        public String toString() {
            return String.format("OutgoingMessage(%db, %dms)", this.elementBytes.length, this.timestampMsSinceEpoch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutgoingMessage that = (OutgoingMessage)o;
            return this.timestampMsSinceEpoch == that.timestampMsSinceEpoch && Arrays.equals(this.elementBytes, that.elementBytes) && Objects.equal(this.recordId, that.recordId);
        }

        public int hashCode() {
            return Objects.hashCode(Arrays.hashCode(this.elementBytes), this.timestampMsSinceEpoch, this.recordId);
        }
    }

    public static class TopicPath
    implements Serializable {
        private final String path;

        TopicPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            String[] splits = this.path.split("/");
            Preconditions.checkState(splits.length == 4, "Malformed topic path %s", this.path);
            return splits[3];
        }

        public String getV1Beta1Path() {
            String[] splits = this.path.split("/");
            Preconditions.checkState(splits.length == 4, "Malformed topic path %s", this.path);
            return String.format("/topics/%s/%s", splits[1], splits[3]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicPath topicPath = (TopicPath)o;
            return this.path.equals(topicPath.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path;
        }
    }

    public static class SubscriptionPath
    implements Serializable {
        private final String projectId;
        private final String subscriptionName;

        SubscriptionPath(String path) {
            String[] splits = path.split("/");
            Preconditions.checkState(splits.length == 4 && splits[0].equals("projects") && splits[2].equals("subscriptions"), "Malformed subscription path %s: must be of the form \"projects/\" + <project id> + \"subscriptions\"", path);
            this.projectId = splits[1];
            this.subscriptionName = splits[3];
        }

        public String getPath() {
            return String.format("projects/%s/subscriptions/%s", this.projectId, this.subscriptionName);
        }

        public String getName() {
            return this.subscriptionName;
        }

        public String getV1Beta1Path() {
            return String.format("/subscriptions/%s/%s", this.projectId, this.subscriptionName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriptionPath that = (SubscriptionPath)o;
            return this.subscriptionName.equals(that.subscriptionName) && this.projectId.equals(that.projectId);
        }

        public int hashCode() {
            return Objects.hashCode(this.projectId, this.subscriptionName);
        }

        public String toString() {
            return this.getPath();
        }
    }

    public static class ProjectPath
    implements Serializable {
        private final String projectId;

        ProjectPath(String path) {
            String[] splits = path.split("/");
            Preconditions.checkArgument(splits.length == 2 && splits[0].equals("projects"), "Malformed project path \"%s\": must be of the form \"projects/\" + <project id>", path);
            this.projectId = splits[1];
        }

        public String getPath() {
            return String.format("projects/%s", this.projectId);
        }

        public String getId() {
            return this.projectId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectPath that = (ProjectPath)o;
            return this.projectId.equals(that.projectId);
        }

        public int hashCode() {
            return this.projectId.hashCode();
        }

        public String toString() {
            return this.getPath();
        }
    }

    public static interface PubsubClientFactory
    extends Serializable {
        public PubsubClient newClient(@Nullable String var1, @Nullable String var2, DataflowPipelineOptions var3) throws IOException;

        public String getKind();
    }
}

