/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.VarLongCoder;
import com.google.cloud.dataflow.sdk.transforms.Sum;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.state.AccumulatorCombiningState;
import com.google.cloud.dataflow.sdk.util.state.MergingStateAccessor;
import com.google.cloud.dataflow.sdk.util.state.ReadableState;
import com.google.cloud.dataflow.sdk.util.state.StateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateMerging;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;

public abstract class NonEmptyPanes<K, W extends BoundedWindow> {
    static <K, W extends BoundedWindow> NonEmptyPanes<K, W> create(WindowingStrategy<?, W> strategy, ReduceFn<K, ?, ?, W> reduceFn) {
        if (strategy.getMode() == WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES) {
            return new DiscardingModeNonEmptyPanes(reduceFn);
        }
        return new GeneralNonEmptyPanes();
    }

    public abstract void recordContent(StateAccessor<K> var1);

    public abstract void clearPane(StateAccessor<K> var1);

    public abstract ReadableState<Boolean> isEmpty(StateAccessor<K> var1);

    public abstract void prefetchOnMerge(MergingStateAccessor<K, W> var1);

    public abstract void onMerge(MergingStateAccessor<K, W> var1);

    private static class GeneralNonEmptyPanes<K, W extends BoundedWindow>
    extends NonEmptyPanes<K, W> {
        private static final StateTag<Object, AccumulatorCombiningState<Long, long[], Long>> PANE_ADDITIONS_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("count", VarLongCoder.of(), new Sum.SumLongFn()));

        private GeneralNonEmptyPanes() {
        }

        @Override
        public void recordContent(StateAccessor<K> state) {
            state.access(PANE_ADDITIONS_TAG).add(1L);
        }

        @Override
        public void clearPane(StateAccessor<K> state) {
            state.access(PANE_ADDITIONS_TAG).clear();
        }

        @Override
        public ReadableState<Boolean> isEmpty(StateAccessor<K> state) {
            return state.access(PANE_ADDITIONS_TAG).isEmpty();
        }

        @Override
        public void prefetchOnMerge(MergingStateAccessor<K, W> state) {
            StateMerging.prefetchCombiningValues(state, PANE_ADDITIONS_TAG);
        }

        @Override
        public void onMerge(MergingStateAccessor<K, W> context) {
            StateMerging.mergeCombiningValues(context, PANE_ADDITIONS_TAG);
        }
    }

    private static class DiscardingModeNonEmptyPanes<K, W extends BoundedWindow>
    extends NonEmptyPanes<K, W> {
        private ReduceFn<K, ?, ?, W> reduceFn;

        private DiscardingModeNonEmptyPanes(ReduceFn<K, ?, ?, W> reduceFn) {
            this.reduceFn = reduceFn;
        }

        @Override
        public ReadableState<Boolean> isEmpty(StateAccessor<K> state) {
            return this.reduceFn.isEmpty(state);
        }

        @Override
        public void recordContent(StateAccessor<K> state) {
        }

        @Override
        public void clearPane(StateAccessor<K> state) {
        }

        @Override
        public void prefetchOnMerge(MergingStateAccessor<K, W> state) {
        }

        @Override
        public void onMerge(MergingStateAccessor<K, W> context) {
        }
    }
}

