/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.JobMessage;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.util.TimeUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public final class MonitoringUtil {
    private static final String GCLOUD_DATAFLOW_PREFIX = "gcloud alpha dataflow";
    private static final String ENDPOINT_OVERRIDE_ENV_VAR = "CLOUDSDK_API_ENDPOINT_OVERRIDES_DATAFLOW";
    private static final Map<String, PipelineResult.State> DATAFLOW_STATE_TO_JOB_STATE = ImmutableMap.builder().put("JOB_STATE_UNKNOWN", PipelineResult.State.UNKNOWN).put("JOB_STATE_STOPPED", PipelineResult.State.STOPPED).put("JOB_STATE_RUNNING", PipelineResult.State.RUNNING).put("JOB_STATE_DONE", PipelineResult.State.DONE).put("JOB_STATE_FAILED", PipelineResult.State.FAILED).put("JOB_STATE_CANCELLED", PipelineResult.State.CANCELLED).put("JOB_STATE_UPDATED", PipelineResult.State.UPDATED).build();
    private String projectId;
    private Dataflow.Projects.Jobs.Messages messagesClient;

    public MonitoringUtil(String projectId, Dataflow dataflow) {
        this(projectId, dataflow.projects().jobs().messages());
    }

    MonitoringUtil(String projectId, Dataflow.Projects.Jobs.Messages messagesClient) {
        this.projectId = projectId;
        this.messagesClient = messagesClient;
    }

    public ArrayList<JobMessage> getJobMessages(String jobId, long startTimestampMs) throws IOException {
        Instant startTimestamp = new Instant(startTimestampMs);
        ArrayList<JobMessage> allMessages = new ArrayList<JobMessage>();
        String pageToken = null;
        while (true) {
            ListJobMessagesResponse response;
            Dataflow.Projects.Jobs.Messages.List listRequest = this.messagesClient.list(this.projectId, jobId);
            if (pageToken != null) {
                listRequest.setPageToken(pageToken);
            }
            if ((response = (ListJobMessagesResponse)listRequest.execute()) == null || response.getJobMessages() == null) {
                return allMessages;
            }
            for (JobMessage m : response.getJobMessages()) {
                Instant timestamp = TimeUtil.fromCloudTime(m.getTime());
                if (timestamp == null || !timestamp.isAfter((ReadableInstant)startTimestamp)) continue;
                allMessages.add(m);
            }
            if (response.getNextPageToken() == null) break;
            pageToken = response.getNextPageToken();
        }
        Collections.sort(allMessages, new TimeStampComparator());
        return allMessages;
    }

    public static String getJobMonitoringPageURL(String projectName, String jobId) {
        try {
            return String.format("https://console.developers.google.com/project/%s/dataflow/job/%s", URLEncoder.encode(projectName, "UTF-8"), URLEncoder.encode(jobId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 encoding is not supported by the environment", e);
        }
    }

    public static String getGcloudCancelCommand(DataflowPipelineOptions options, String jobId) {
        String dataflowApiOverridePrefix = "";
        String apiUrl = options.getDataflowClient().getBaseUrl();
        if (!apiUrl.equals("https://dataflow.googleapis.com/")) {
            dataflowApiOverridePrefix = String.format("%s=%s ", ENDPOINT_OVERRIDE_ENV_VAR, apiUrl);
        }
        return String.format("%s%s jobs --project=%s cancel %s", dataflowApiOverridePrefix, GCLOUD_DATAFLOW_PREFIX, options.getProject(), jobId);
    }

    public static PipelineResult.State toState(String stateName) {
        return MoreObjects.firstNonNull(DATAFLOW_STATE_TO_JOB_STATE.get(stateName), PipelineResult.State.UNKNOWN);
    }

    public static class TimeStampComparator
    implements Comparator<JobMessage> {
        @Override
        public int compare(JobMessage o1, JobMessage o2) {
            Instant t1 = TimeUtil.fromCloudTime(o1.getTime());
            if (t1 == null) {
                return -1;
            }
            Instant t2 = TimeUtil.fromCloudTime(o2.getTime());
            if (t2 == null) {
                return 1;
            }
            return t1.compareTo((ReadableInstant)t2);
        }
    }

    public static class PrintHandler
    implements JobMessagesHandler {
        private PrintStream out;

        public PrintHandler(PrintStream stream) {
            this.out = stream;
        }

        @Override
        public void process(List<JobMessage> messages) {
            for (JobMessage message : messages) {
                if (message.getMessageText() == null || message.getMessageText().isEmpty()) continue;
                String importanceString = null;
                if (message.getMessageImportance() == null) continue;
                if (message.getMessageImportance().equals("JOB_MESSAGE_ERROR")) {
                    importanceString = "Error:   ";
                } else if (message.getMessageImportance().equals("JOB_MESSAGE_WARNING")) {
                    importanceString = "Warning: ";
                } else if (message.getMessageImportance().equals("JOB_MESSAGE_BASIC")) {
                    importanceString = "Basic:  ";
                } else {
                    if (!message.getMessageImportance().equals("JOB_MESSAGE_DETAILED")) continue;
                    importanceString = "Detail:  ";
                }
                Instant time = TimeUtil.fromCloudTime(message.getTime());
                if (time == null) {
                    this.out.print("UNKNOWN TIMESTAMP: ");
                } else {
                    this.out.print(time + ": ");
                }
                if (importanceString != null) {
                    this.out.print(importanceString);
                }
                this.out.println(message.getMessageText());
            }
            this.out.flush();
        }
    }

    public static interface JobMessagesHandler {
        public void process(List<JobMessage> var1);
    }
}

