/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.options.GcsOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.util.FileIOChannelFactory;
import com.google.cloud.dataflow.sdk.util.GcsIOChannelFactory;
import com.google.cloud.dataflow.sdk.util.IOChannelFactory;
import com.google.cloud.dataflow.sdk.util.ShardingWritableByteChannel;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IOChannelUtils {
    private static final Map<String, IOChannelFactory> FACTORY_MAP = Collections.synchronizedMap(new HashMap());
    private static final Pattern SHARD_FORMAT_RE = Pattern.compile("(S+|N+)");
    private static final Pattern URI_SCHEME_PATTERN = Pattern.compile("(?<scheme>[a-zA-Z][-a-zA-Z0-9+.]*)://.*");

    public static void setIOFactory(String scheme, IOChannelFactory factory) {
        FACTORY_MAP.put(scheme, factory);
    }

    public static void registerStandardIOFactories(PipelineOptions options) {
        IOChannelUtils.setIOFactory("gs", new GcsIOChannelFactory(options.as(GcsOptions.class)));
    }

    public static WritableByteChannel create(String filename, String mimeType) throws IOException {
        return IOChannelUtils.getFactory(filename).create(filename, mimeType);
    }

    public static WritableByteChannel create(String prefix, String shardTemplate, String suffix, int numShards, String mimeType) throws IOException {
        if (numShards == 1) {
            return IOChannelUtils.create(IOChannelUtils.constructName(prefix, shardTemplate, suffix, 0, 1), mimeType);
        }
        ShardingWritableByteChannel shardingChannel = new ShardingWritableByteChannel();
        HashSet<String> outputNames = new HashSet<String>();
        for (int i = 0; i < numShards; ++i) {
            String outputName = IOChannelUtils.constructName(prefix, shardTemplate, suffix, i, numShards);
            if (!outputNames.add(outputName)) {
                throw new IllegalArgumentException("Shard name collision detected for: " + outputName);
            }
            WritableByteChannel channel = IOChannelUtils.create(outputName, mimeType);
            shardingChannel.addChannel(channel);
        }
        return shardingChannel;
    }

    public static long getSizeBytes(String spec) throws IOException {
        return IOChannelUtils.getFactory(spec).getSizeBytes(spec);
    }

    public static String constructName(String prefix, String shardTemplate, String suffix, int shardNum, int numShards) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        Matcher m = SHARD_FORMAT_RE.matcher(shardTemplate);
        while (m.find()) {
            boolean isShardNum = m.group(1).charAt(0) == 'S';
            char[] zeros = new char[m.end() - m.start()];
            Arrays.fill(zeros, '0');
            DecimalFormat df = new DecimalFormat(String.valueOf(zeros));
            String formatted = df.format(isShardNum ? (long)shardNum : (long)numShards);
            m.appendReplacement(sb, formatted);
        }
        m.appendTail(sb);
        sb.append(suffix);
        return sb.toString();
    }

    public static IOChannelFactory getFactory(String spec) throws IOException {
        Matcher matcher = URI_SCHEME_PATTERN.matcher(spec);
        if (!matcher.matches()) {
            return new FileIOChannelFactory();
        }
        String scheme = matcher.group("scheme");
        IOChannelFactory ioFactory = FACTORY_MAP.get(scheme);
        if (ioFactory != null) {
            return ioFactory;
        }
        throw new IOException("Unable to find handler for " + spec);
    }

    public static String resolve(String path, String other) throws IOException {
        return IOChannelUtils.getFactory(path).resolve(path, other);
    }
}

