/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.DoFnRunner;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.KeyedWorkItem;
import com.google.cloud.dataflow.sdk.util.LateDataDroppingDoFnRunner;
import com.google.cloud.dataflow.sdk.util.SideInputReader;
import com.google.cloud.dataflow.sdk.util.SimpleDoFnRunner;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import java.util.List;

public class DoFnRunners {
    public static <InputT, OutputT> DoFnRunner<InputT, OutputT> simpleRunner(PipelineOptions options, DoFn<InputT, OutputT> fn, SideInputReader sideInputReader, OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> sideOutputTags, ExecutionContext.StepContext stepContext, CounterSet.AddCounterMutator addCounterMutator, WindowingStrategy<?, ?> windowingStrategy) {
        return new SimpleDoFnRunner<InputT, OutputT>(options, fn, sideInputReader, outputManager, mainOutputTag, sideOutputTags, stepContext, addCounterMutator, windowingStrategy);
    }

    public static <K, InputT, OutputT, W extends BoundedWindow> DoFnRunner<KeyedWorkItem<K, InputT>, KV<K, OutputT>> lateDataDroppingRunner(PipelineOptions options, DoFnRunner.ReduceFnExecutor<K, InputT, OutputT, W> reduceFnExecutor, SideInputReader sideInputReader, OutputManager outputManager, TupleTag<KV<K, OutputT>> mainOutputTag, List<TupleTag<?>> sideOutputTags, ExecutionContext.StepContext stepContext, CounterSet.AddCounterMutator addCounterMutator, WindowingStrategy<?, W> windowingStrategy) {
        DoFnRunner<KeyedWorkItem<K, InputT>, KV<K, OutputT>> simpleDoFnRunner = DoFnRunners.simpleRunner(options, reduceFnExecutor.asDoFn(), sideInputReader, outputManager, mainOutputTag, sideOutputTags, stepContext, addCounterMutator, windowingStrategy);
        return new LateDataDroppingDoFnRunner(simpleDoFnRunner, windowingStrategy, stepContext.timerInternals(), reduceFnExecutor.getDroppedDueToLatenessAggregator());
    }

    public static <InputT, OutputT> DoFnRunner<InputT, OutputT> createDefault(PipelineOptions options, DoFn<InputT, OutputT> doFn, SideInputReader sideInputReader, OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> sideOutputTags, ExecutionContext.StepContext stepContext, CounterSet.AddCounterMutator addCounterMutator, WindowingStrategy<?, ?> windowingStrategy) {
        if (doFn instanceof DoFnRunner.ReduceFnExecutor) {
            DoFnRunner.ReduceFnExecutor fn = (DoFnRunner.ReduceFnExecutor)((Object)doFn);
            return DoFnRunners.lateDataDroppingRunner(options, fn, sideInputReader, outputManager, mainOutputTag, sideOutputTags, stepContext, addCounterMutator, windowingStrategy);
        }
        return DoFnRunners.simpleRunner(options, doFn, sideInputReader, outputManager, mainOutputTag, sideOutputTags, stepContext, addCounterMutator, windowingStrategy);
    }

    public static interface OutputManager {
        public <T> void output(TupleTag<T> var1, WindowedValue<T> var2);
    }
}

