/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicate;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindows;
import com.google.cloud.dataflow.sdk.util.PTuple;
import com.google.cloud.dataflow.sdk.util.SideInputReader;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.TupleTag;

public class DirectSideInputReader
implements SideInputReader {
    private PTuple sideInputValues;

    private DirectSideInputReader(PTuple sideInputValues) {
        this.sideInputValues = sideInputValues;
    }

    public static DirectSideInputReader of(PTuple sideInputValues) {
        return new DirectSideInputReader(sideInputValues);
    }

    @Override
    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputValues.has(view.getTagInternal());
    }

    @Override
    public boolean isEmpty() {
        return this.sideInputValues.isEmpty();
    }

    @Override
    public <T> T get(PCollectionView<T> view, final BoundedWindow window) {
        TupleTag<Iterable<WindowedValue<?>>> tag = view.getTagInternal();
        if (!this.sideInputValues.has(tag)) {
            throw new IllegalArgumentException("calling getSideInput() with unknown view");
        }
        if (view.getWindowingStrategyInternal().getWindowFn() instanceof GlobalWindows) {
            return view.fromIterableInternal(this.sideInputValues.get(tag));
        }
        return view.fromIterableInternal(Iterables.filter(this.sideInputValues.get(tag), new Predicate<WindowedValue<?>>(){

            @Override
            public boolean apply(WindowedValue<?> element) {
                return element.getWindows().contains(window);
            }
        }));
    }
}

