/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataflowReleaseInfo
extends GenericJson {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowReleaseInfo.class);
    private static final String DATAFLOW_PROPERTIES_PATH = "/com/google/cloud/dataflow/sdk/sdk.properties";
    @Key
    private String name = "Google Cloud Dataflow SDK for Java";
    @Key
    private String version = "Unknown";

    public static DataflowReleaseInfo getReleaseInfo() {
        return LazyInit.INSTANCE;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    private DataflowReleaseInfo(String resourcePath) {
        Properties properties = new Properties();
        InputStream in = DataflowReleaseInfo.class.getResourceAsStream(DATAFLOW_PROPERTIES_PATH);
        if (in == null) {
            LOG.warn("Dataflow properties resource not found: {}", (Object)resourcePath);
            return;
        }
        try {
            properties.load(in);
        }
        catch (IOException e) {
            LOG.warn("Error loading Dataflow properties resource: ", (Throwable)e);
        }
        for (String name : properties.stringPropertyNames()) {
            if (name.equals("name")) continue;
            this.put(name, properties.getProperty(name));
        }
    }

    private static class LazyInit {
        private static final DataflowReleaseInfo INSTANCE = new DataflowReleaseInfo("/com/google/cloud/dataflow/sdk/sdk.properties");

        private LazyInit() {
        }
    }
}

