/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.PathValidator;
import com.google.cloud.dataflow.sdk.util.gcsfs.GcsPath;
import java.io.IOException;

public class DataflowPathValidator
implements PathValidator {
    private DataflowPipelineOptions dataflowOptions;

    DataflowPathValidator(DataflowPipelineOptions options) {
        this.dataflowOptions = options;
    }

    public static DataflowPathValidator fromOptions(PipelineOptions options) {
        return new DataflowPathValidator(options.as(DataflowPipelineOptions.class));
    }

    @Override
    public String validateInputFilePatternSupported(String filepattern) {
        GcsPath gcsPath = this.getGcsPath(filepattern);
        Preconditions.checkArgument(this.dataflowOptions.getGcsUtil().isGcsPatternSupported(gcsPath.getObject()));
        String returnValue = this.verifyPath(filepattern);
        this.verifyPathIsAccessible(filepattern, "Could not find file %s");
        return returnValue;
    }

    @Override
    public String validateOutputFilePrefixSupported(String filePrefix) {
        String returnValue = this.verifyPath(filePrefix);
        this.verifyPathIsAccessible(filePrefix, "Output path does not exist or is not writeable: %s");
        return returnValue;
    }

    @Override
    public String verifyPath(String path) {
        GcsPath gcsPath = this.getGcsPath(path);
        Preconditions.checkArgument(gcsPath.isAbsolute(), "Must provide absolute paths for Dataflow");
        Preconditions.checkArgument(!gcsPath.getObject().contains("//"), "Dataflow Service does not allow objects with consecutive slashes");
        return gcsPath.toResourceName();
    }

    private void verifyPathIsAccessible(String path, String errorMessage) {
        GcsPath gcsPath = this.getGcsPath(path);
        try {
            Preconditions.checkArgument(this.dataflowOptions.getGcsUtil().bucketExists(gcsPath), errorMessage, path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to verify that GCS bucket gs://%s exists.", gcsPath.getBucket()), e);
        }
    }

    private GcsPath getGcsPath(String path) {
        try {
            return GcsPath.fromUri(path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("%s expected a valid 'gs://' path but was given '%s'", this.dataflowOptions.getRunner().getSimpleName(), path), e);
        }
    }
}

