/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.CombineFnBase;
import com.google.cloud.dataflow.sdk.transforms.CombineWithContext;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.util.CombineContextFactory;
import com.google.cloud.dataflow.sdk.util.state.StateContext;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;

public class CombineFnUtil {
    public static <K, InputT, AccumT, OutputT> Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> bindContext(CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> combineFn, StateContext<?> stateContext) {
        CombineWithContext.Context context = CombineContextFactory.createFromStateContext(stateContext);
        return new NonSerializableBoundedKeyedCombineFn(combineFn, context);
    }

    public static <InputT, AccumT, OutputT> CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> toFnWithContext(CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> globalCombineFn) {
        if (globalCombineFn instanceof CombineWithContext.CombineFnWithContext) {
            CombineWithContext.CombineFnWithContext combineFnWithContext = (CombineWithContext.CombineFnWithContext)globalCombineFn;
            return combineFnWithContext;
        }
        final Combine.CombineFn combineFn = (Combine.CombineFn)globalCombineFn;
        return new CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT>(){

            @Override
            public AccumT createAccumulator(CombineWithContext.Context c) {
                return combineFn.createAccumulator();
            }

            @Override
            public AccumT addInput(AccumT accumulator, InputT input, CombineWithContext.Context c) {
                return combineFn.addInput(accumulator, input);
            }

            @Override
            public AccumT mergeAccumulators(Iterable<AccumT> accumulators, CombineWithContext.Context c) {
                return combineFn.mergeAccumulators(accumulators);
            }

            @Override
            public OutputT extractOutput(AccumT accumulator, CombineWithContext.Context c) {
                return combineFn.extractOutput(accumulator);
            }

            @Override
            public AccumT compact(AccumT accumulator, CombineWithContext.Context c) {
                return combineFn.compact(accumulator);
            }

            @Override
            public OutputT defaultValue() {
                return combineFn.defaultValue();
            }

            @Override
            public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                return combineFn.getAccumulatorCoder(registry, inputCoder);
            }

            @Override
            public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                return combineFn.getDefaultOutputCoder(registry, inputCoder);
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                combineFn.populateDisplayData(builder);
            }
        };
    }

    private static class NonSerializableBoundedKeyedCombineFn<K, InputT, AccumT, OutputT>
    extends Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> {
        private final CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> combineFn;
        private final CombineWithContext.Context context;

        private NonSerializableBoundedKeyedCombineFn(CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> combineFn, CombineWithContext.Context context) {
            this.combineFn = combineFn;
            this.context = context;
        }

        @Override
        public AccumT createAccumulator(K key) {
            return this.combineFn.createAccumulator(key, this.context);
        }

        @Override
        public AccumT addInput(K key, AccumT accumulator, InputT value) {
            return this.combineFn.addInput(key, accumulator, value, this.context);
        }

        @Override
        public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators) {
            return this.combineFn.mergeAccumulators(key, accumulators, this.context);
        }

        @Override
        public OutputT extractOutput(K key, AccumT accumulator) {
            return this.combineFn.extractOutput(key, accumulator, this.context);
        }

        @Override
        public AccumT compact(K key, AccumT accumulator) {
            return this.combineFn.compact(key, accumulator, this.context);
        }

        @Override
        public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return this.combineFn.getAccumulatorCoder(registry, (Coder)keyCoder, (Coder)inputCoder);
        }

        @Override
        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return this.combineFn.getDefaultOutputCoder(registry, (Coder)keyCoder, (Coder)inputCoder);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            this.combineFn.populateDisplayData(builder);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new NotSerializableException("Cannot serialize the CombineFn resulting from CombineFnUtil.bindContext.");
        }
    }
}

