/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.transforms.CombineWithContext;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.SideInputReader;
import com.google.cloud.dataflow.sdk.util.state.StateContext;
import com.google.cloud.dataflow.sdk.values.PCollectionView;

public class CombineContextFactory {
    private static final CombineWithContext.Context NULL_CONTEXT = new CombineWithContext.Context(){

        @Override
        public PipelineOptions getPipelineOptions() {
            throw new IllegalArgumentException("cannot call getPipelineOptions() in a null context");
        }

        @Override
        public <T> T sideInput(PCollectionView<T> view) {
            throw new IllegalArgumentException("cannot call sideInput() in a null context");
        }
    };

    public static CombineWithContext.Context nullContext() {
        return NULL_CONTEXT;
    }

    public static CombineWithContext.Context createFromProcessContext(final DoFn.ProcessContext c) {
        return new CombineWithContext.Context(){

            @Override
            public PipelineOptions getPipelineOptions() {
                return c.getPipelineOptions();
            }

            @Override
            public <T> T sideInput(PCollectionView<T> view) {
                return c.sideInput(view);
            }
        };
    }

    public static CombineWithContext.Context createFromStateContext(final StateContext<?> c) {
        return new CombineWithContext.Context(){

            @Override
            public PipelineOptions getPipelineOptions() {
                return c.getPipelineOptions();
            }

            @Override
            public <T> T sideInput(PCollectionView<T> view) {
                return c.sideInput(view);
            }
        };
    }

    public static CombineWithContext.Context createFromComponents(final PipelineOptions options, final SideInputReader sideInputReader, final BoundedWindow mainInputWindow) {
        return new CombineWithContext.Context(){

            @Override
            public PipelineOptions getPipelineOptions() {
                return options;
            }

            @Override
            public <T> T sideInput(PCollectionView<T> view) {
                if (!sideInputReader.contains(view)) {
                    throw new IllegalArgumentException("calling sideInput() with unknown view");
                }
                Object sideInputWindow = view.getWindowingStrategyInternal().getWindowFn().getSideInputWindow(mainInputWindow);
                return sideInputReader.get(view, (BoundedWindow)sideInputWindow);
            }
        };
    }
}

