/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.ByteArrayCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;

class BitSetCoder
extends AtomicCoder<BitSet> {
    private static final BitSetCoder INSTANCE = new BitSetCoder();
    private transient ByteArrayCoder byteArrayCoder = ByteArrayCoder.of();

    private BitSetCoder() {
    }

    public static BitSetCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode(BitSet value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        this.byteArrayCoder.encodeAndOwn(value.toByteArray(), outStream, context);
    }

    @Override
    public BitSet decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        return BitSet.valueOf(this.byteArrayCoder.decode(inStream, context));
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.verifyDeterministic("BitSetCoder requires its byteArrayCoder to be deterministic.", this.byteArrayCoder);
    }
}

