/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.dataflow.sdk.options.BigQueryOptions;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public interface BigQueryServices
extends Serializable {
    public JobService getJobService(BigQueryOptions var1);

    public DatasetService getDatasetService(BigQueryOptions var1);

    public BigQueryJsonReader getReaderFromTable(BigQueryOptions var1, TableReference var2);

    public BigQueryJsonReader getReaderFromQuery(BigQueryOptions var1, String var2, String var3, @Nullable Boolean var4);

    public static interface BigQueryJsonReader {
        public boolean start() throws IOException;

        public boolean advance() throws IOException;

        public TableRow getCurrent() throws NoSuchElementException;

        public void close() throws IOException;
    }

    public static interface DatasetService {
        public Table getTable(String var1, String var2, String var3) throws InterruptedException, IOException;

        public void deleteTable(String var1, String var2, String var3) throws IOException, InterruptedException;

        public void createDataset(String var1, String var2, String var3, String var4) throws IOException, InterruptedException;

        public void deleteDataset(String var1, String var2) throws IOException, InterruptedException;
    }

    public static interface JobService {
        public void startLoadJob(JobReference var1, JobConfigurationLoad var2) throws InterruptedException, IOException;

        public void startExtractJob(JobReference var1, JobConfigurationExtract var2) throws InterruptedException, IOException;

        public void startQueryJob(JobReference var1, JobConfigurationQuery var2) throws IOException, InterruptedException;

        public void startCopyJob(JobReference var1, JobConfigurationTableCopy var2) throws IOException, InterruptedException;

        public Job pollJob(JobReference var1, int var2) throws InterruptedException, IOException;

        public JobStatistics dryRunQuery(String var1, String var2) throws InterruptedException, IOException;

        public Job getJob(JobReference var1) throws IOException, InterruptedException;
    }
}

