/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import com.google.cloud.dataflow.sdk.util.SystemDoFnInternal;
import java.util.Collection;
import org.joda.time.Instant;

@SystemDoFnInternal
public class AssignWindowsDoFn<T, W extends BoundedWindow>
extends DoFn<T, T> {
    private WindowFn<? super T, W> fn;

    public AssignWindowsDoFn(WindowFn<? super T, W> fn) {
        this.fn = fn;
    }

    @Override
    public void processElement(final DoFn.ProcessContext c) throws Exception {
        WindowFn<T, W> windowFn = this.fn;
        windowFn.getClass();
        Collection<W> windows = this.fn.assignWindows(new WindowFn.AssignContext(windowFn){

            @Override
            public T element() {
                return c.element();
            }

            @Override
            public Instant timestamp() {
                return c.timestamp();
            }

            @Override
            public Collection<? extends BoundedWindow> windows() {
                return c.windowingInternals().windows();
            }
        });
        c.windowingInternals().outputWindowedValue(c.element(), c.timestamp(), windows, PaneInfo.NO_FIRING);
    }
}

