/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.OrFinallyTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.TriggerBuilder;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.state.MergingStateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateAccessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public abstract class Trigger<W extends BoundedWindow>
implements Serializable,
TriggerBuilder<W> {
    @Nullable
    protected final List<Trigger<W>> subTriggers;

    protected Trigger(@Nullable List<Trigger<W>> subTriggers) {
        this.subTriggers = subTriggers;
    }

    public abstract void onElement(OnElementContext var1) throws Exception;

    public abstract void onMerge(OnMergeContext var1) throws Exception;

    public abstract boolean shouldFire(TriggerContext var1) throws Exception;

    public abstract void onFire(TriggerContext var1) throws Exception;

    public void prefetchOnElement(StateAccessor<?> state) {
        if (this.subTriggers != null) {
            for (Trigger<W> trigger : this.subTriggers) {
                trigger.prefetchOnElement(state);
            }
        }
    }

    public void prefetchOnMerge(MergingStateAccessor<?, W> state) {
        if (this.subTriggers != null) {
            for (Trigger<W> trigger : this.subTriggers) {
                trigger.prefetchOnMerge(state);
            }
        }
    }

    public void prefetchShouldFire(StateAccessor<?> state) {
        if (this.subTriggers != null) {
            for (Trigger<W> trigger : this.subTriggers) {
                trigger.prefetchShouldFire(state);
            }
        }
    }

    public void prefetchOnFire(StateAccessor<?> state) {
        if (this.subTriggers != null) {
            for (Trigger<W> trigger : this.subTriggers) {
                trigger.prefetchOnFire(state);
            }
        }
    }

    public void clear(TriggerContext c) throws Exception {
        if (this.subTriggers != null) {
            for (ExecutableTrigger trigger : c.trigger().subTriggers()) {
                trigger.invokeClear(c);
            }
        }
    }

    public Iterable<Trigger<W>> subTriggers() {
        return this.subTriggers;
    }

    public Trigger<W> getContinuationTrigger() {
        if (this.subTriggers == null) {
            return this.getContinuationTrigger(null);
        }
        ArrayList<Trigger<W>> subTriggerContinuations = new ArrayList<Trigger<W>>();
        for (Trigger<W> subTrigger : this.subTriggers) {
            subTriggerContinuations.add(subTrigger.getContinuationTrigger());
        }
        return this.getContinuationTrigger(subTriggerContinuations);
    }

    protected abstract Trigger<W> getContinuationTrigger(List<Trigger<W>> var1);

    public abstract Instant getWatermarkThatGuaranteesFiring(W var1);

    public boolean isCompatible(Trigger<?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.subTriggers == null) {
            return other.subTriggers == null;
        }
        if (other.subTriggers == null) {
            return false;
        }
        if (this.subTriggers.size() != other.subTriggers.size()) {
            return false;
        }
        for (int i = 0; i < this.subTriggers.size(); ++i) {
            if (this.subTriggers.get(i).isCompatible(other.subTriggers.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        if (this.getClass().getEnclosingClass() != null) {
            simpleName = this.getClass().getEnclosingClass().getSimpleName() + "." + simpleName;
        }
        if (this.subTriggers == null || this.subTriggers.size() == 0) {
            return simpleName;
        }
        return simpleName + "(" + Joiner.on(", ").join(this.subTriggers) + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        Trigger that = (Trigger)obj;
        return Objects.equals(this.getClass(), that.getClass()) && Objects.equals(this.subTriggers, that.subTriggers);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.subTriggers);
    }

    public Trigger<W> orFinally(OnceTrigger<W> until) {
        return new OrFinallyTrigger<W>(this, until);
    }

    @Override
    public Trigger<W> buildTrigger() {
        return this;
    }

    public static abstract class OnceTrigger<W extends BoundedWindow>
    extends Trigger<W> {
        protected OnceTrigger(List<Trigger<W>> subTriggers) {
            super(subTriggers);
        }

        @Override
        public final OnceTrigger<W> getContinuationTrigger() {
            Trigger continuation = super.getContinuationTrigger();
            if (!(continuation instanceof OnceTrigger)) {
                throw new IllegalStateException("Continuation of a OnceTrigger must be a OnceTrigger");
            }
            return (OnceTrigger)continuation;
        }

        @Override
        public final void onFire(TriggerContext context) throws Exception {
            this.onOnlyFiring(context);
            context.trigger().setFinished(true);
        }

        protected abstract void onOnlyFiring(TriggerContext var1) throws Exception;
    }

    public abstract class OnMergeContext
    extends TriggerContext {
        public abstract void setTimer(Instant var1, TimeDomain var2);

        @Override
        public abstract OnMergeContext forTrigger(ExecutableTrigger<W> var1);

        public abstract MergingStateAccessor<?, W> state();

        public abstract MergingTriggerInfo<W> trigger();
    }

    public abstract class OnElementContext
    extends TriggerContext {
        public abstract Instant eventTimestamp();

        public abstract void setTimer(Instant var1, TimeDomain var2);

        @Override
        public abstract OnElementContext forTrigger(ExecutableTrigger<W> var1);
    }

    public abstract class TriggerContext {
        public abstract TriggerInfo<W> trigger();

        public abstract StateAccessor<?> state();

        public abstract W window();

        public abstract TriggerContext forTrigger(ExecutableTrigger<W> var1);

        public abstract void deleteTimer(Instant var1, TimeDomain var2);

        public abstract Instant currentProcessingTime();

        @Nullable
        public abstract Instant currentSynchronizedProcessingTime();

        @Nullable
        public abstract Instant currentEventTime();
    }

    public static interface MergingTriggerInfo<W extends BoundedWindow>
    extends TriggerInfo<W> {
        public boolean finishedInAnyMergingWindow();

        public boolean finishedInAllMergingWindows();

        public Iterable<W> getFinishedMergingWindows();
    }

    public static interface TriggerInfo<W extends BoundedWindow> {
        public boolean isMerging();

        public Iterable<ExecutableTrigger<W>> subTriggers();

        public ExecutableTrigger<W> subTrigger(int var1);

        public boolean isFinished();

        public boolean isFinished(int var1);

        public boolean areAllSubtriggersFinished();

        public Iterable<ExecutableTrigger<W>> unfinishedSubTriggers();

        public ExecutableTrigger<W> firstUnfinishedSubTrigger();

        public void resetTree() throws Exception;

        public void setFinished(boolean var1);

        public void setFinished(boolean var1, int var2);
    }
}

