/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.IntervalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.MergeOverlappingIntervalWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFns;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class Sessions
extends WindowFn<Object, IntervalWindow> {
    private final Duration gapDuration;

    public static Sessions withGapDuration(Duration gapDuration) {
        return new Sessions(gapDuration);
    }

    private Sessions(Duration gapDuration) {
        this.gapDuration = gapDuration;
    }

    @Override
    public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) {
        return Arrays.asList(new IntervalWindow(c.timestamp(), (ReadableDuration)this.gapDuration));
    }

    @Override
    public void mergeWindows(WindowFn.MergeContext c) throws Exception {
        MergeOverlappingIntervalWindows.mergeWindows(c);
    }

    @Override
    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        return other instanceof Sessions;
    }

    @Override
    public IntervalWindow getSideInputWindow(BoundedWindow window) {
        throw new UnsupportedOperationException("Sessions is not allowed in side inputs");
    }

    @Override
    @Experimental(value=Experimental.Kind.OUTPUT_TIME)
    public OutputTimeFn<? super IntervalWindow> getOutputTimeFn() {
        return OutputTimeFns.outputAtEarliestInputTimestamp();
    }

    public Duration getGapDuration() {
        return this.gapDuration;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("gapDuration", this.gapDuration).withLabel("Session Gap Duration"));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Sessions)) {
            return false;
        }
        Sessions other = (Sessions)object;
        return this.getGapDuration().equals((Object)other.getGapDuration());
    }

    public int hashCode() {
        return Objects.hash(this.gapDuration);
    }
}

