/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Ordering;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.OUTPUT_TIME)
public class OutputTimeFns {
    public static OutputTimeFn<BoundedWindow> outputAtEarliestInputTimestamp() {
        return new OutputAtEarliestInputTimestamp();
    }

    public static OutputTimeFn<BoundedWindow> outputAtLatestInputTimestamp() {
        return new OutputAtLatestInputTimestamp();
    }

    public static OutputTimeFn<BoundedWindow> outputAtEndOfWindow() {
        return new OutputAtEndOfWindow();
    }

    public static Instant combineOutputTimes(OutputTimeFn<?> outputTimeFn, Iterable<? extends Instant> outputTimes) {
        Preconditions.checkArgument(!Iterables.isEmpty(outputTimes), "Collection of output times must not be empty in %s.combineOutputTimes", OutputTimeFns.class.getName());
        Instant combinedOutputTime = null;
        for (Instant instant : outputTimes) {
            combinedOutputTime = combinedOutputTime == null ? instant : outputTimeFn.combine(combinedOutputTime, instant);
        }
        return combinedOutputTime;
    }

    private static class OutputAtEndOfWindow
    extends OutputTimeFn.DependsOnlyOnWindow<BoundedWindow> {
        private OutputAtEndOfWindow() {
        }

        @Override
        protected Instant assignOutputTime(BoundedWindow window) {
            return window.maxTimestamp();
        }
    }

    private static class OutputAtLatestInputTimestamp
    extends OutputTimeFn.Defaults<BoundedWindow> {
        private OutputAtLatestInputTimestamp() {
        }

        @Override
        public Instant assignOutputTime(Instant inputTimestamp, BoundedWindow window) {
            return inputTimestamp;
        }

        @Override
        public Instant combine(Instant outputTime, Instant otherOutputTime) {
            return Ordering.natural().max(outputTime, otherOutputTime);
        }

        @Override
        public boolean dependsOnlyOnEarliestInputTimestamp() {
            return false;
        }
    }

    private static class OutputAtEarliestInputTimestamp
    extends OutputTimeFn.Defaults<BoundedWindow> {
        private OutputAtEarliestInputTimestamp() {
        }

        @Override
        public Instant assignOutputTime(Instant inputTimestamp, BoundedWindow window) {
            return inputTimestamp;
        }

        @Override
        public Instant combine(Instant outputTime, Instant otherOutputTime) {
            return Ordering.natural().min(outputTime, otherOutputTime);
        }

        @Override
        public boolean dependsOnlyOnEarliestInputTimestamp() {
            return true;
        }
    }
}

