/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Ordering;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFns;
import java.io.Serializable;
import java.util.Objects;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.OUTPUT_TIME)
public abstract class OutputTimeFn<W extends BoundedWindow>
implements Serializable {
    private OutputTimeFn() {
    }

    public abstract Instant assignOutputTime(Instant var1, W var2);

    public abstract Instant combine(Instant var1, Instant var2);

    public abstract Instant merge(W var1, Iterable<? extends Instant> var2);

    public abstract boolean dependsOnlyOnEarliestInputTimestamp();

    public abstract boolean dependsOnlyOnWindow();

    public static abstract class DependsOnlyOnWindow<W extends BoundedWindow>
    extends OutputTimeFn<W> {
        protected DependsOnlyOnWindow() {
        }

        protected abstract Instant assignOutputTime(W var1);

        @Override
        public final Instant assignOutputTime(Instant timestamp, W window) {
            return this.assignOutputTime(window);
        }

        @Override
        public final Instant combine(Instant outputTimestamp, Instant otherOutputTimestamp) {
            return outputTimestamp;
        }

        @Override
        public final Instant merge(W resultWindow, Iterable<? extends Instant> mergingTimestamps) {
            return this.assignOutputTime(resultWindow);
        }

        @Override
        public final boolean dependsOnlyOnWindow() {
            return true;
        }

        @Override
        public final boolean dependsOnlyOnEarliestInputTimestamp() {
            return true;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            return this.getClass().equals(other.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }
    }

    public static abstract class Defaults<W extends BoundedWindow>
    extends OutputTimeFn<W> {
        protected Defaults() {
        }

        @Override
        public Instant combine(Instant outputTimestamp, Instant otherOutputTimestamp) {
            return Ordering.natural().min(outputTimestamp, otherOutputTimestamp);
        }

        @Override
        public Instant merge(W resultWindow, Iterable<? extends Instant> mergingTimestamps) {
            return OutputTimeFns.combineOutputTimes(this, mergingTimestamps);
        }

        @Override
        public final boolean dependsOnlyOnWindow() {
            return false;
        }

        @Override
        public boolean dependsOnlyOnEarliestInputTimestamp() {
            return false;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            return this.getClass().equals(other.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }
    }
}

