/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import java.util.List;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class DefaultTrigger<W extends BoundedWindow>
extends Trigger<W> {
    private DefaultTrigger() {
        super(null);
    }

    public static <W extends BoundedWindow> DefaultTrigger<W> of() {
        return new DefaultTrigger<W>();
    }

    @Override
    public void onElement(Trigger.OnElementContext c) throws Exception {
        if (!this.endOfWindowReached(c)) {
            c.setTimer(((BoundedWindow)c.window()).maxTimestamp(), TimeDomain.EVENT_TIME);
        }
    }

    @Override
    public void onMerge(Trigger.OnMergeContext c) throws Exception {
        if (!this.endOfWindowReached(c)) {
            c.setTimer(((BoundedWindow)c.window()).maxTimestamp(), TimeDomain.EVENT_TIME);
        }
    }

    @Override
    public void clear(Trigger.TriggerContext c) throws Exception {
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return ((BoundedWindow)window).maxTimestamp();
    }

    @Override
    public boolean isCompatible(Trigger<?> other) {
        return other instanceof DefaultTrigger;
    }

    @Override
    public Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return this;
    }

    @Override
    public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
        return this.endOfWindowReached(context);
    }

    private boolean endOfWindowReached(Trigger.TriggerContext context) {
        return context.currentEventTime() != null && context.currentEventTime().isAfter((ReadableInstant)((BoundedWindow)context.window()).maxTimestamp());
    }

    @Override
    public void onFire(Trigger.TriggerContext context) throws Exception {
    }
}

