/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Never;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.TriggerBuilder;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterWatermark<W extends BoundedWindow> {
    private static final String TO_STRING = "AfterWatermark.pastEndOfWindow()";

    private AfterWatermark() {
    }

    public static <W extends BoundedWindow> FromEndOfWindow<W> pastEndOfWindow() {
        return new FromEndOfWindow();
    }

    public static class FromEndOfWindow<W extends BoundedWindow>
    extends Trigger.OnceTrigger<W> {
        private FromEndOfWindow() {
            super(null);
        }

        public AfterWatermarkEarly<W> withEarlyFirings(Trigger.OnceTrigger<W> earlyFirings) {
            Preconditions.checkNotNull(earlyFirings, "Must specify the trigger to use for early firings");
            return new AfterWatermarkEarlyAndLate(earlyFirings, null);
        }

        public AfterWatermarkLate<W> withLateFirings(Trigger.OnceTrigger<W> lateFirings) {
            Preconditions.checkNotNull(lateFirings, "Must specify the trigger to use for late firings");
            return new AfterWatermarkEarlyAndLate(Never.ever(), lateFirings);
        }

        @Override
        public void onElement(Trigger.OnElementContext c) throws Exception {
            c.setTimer(((BoundedWindow)c.window()).maxTimestamp(), TimeDomain.EVENT_TIME);
        }

        @Override
        public void onMerge(Trigger.OnMergeContext c) throws Exception {
            if (!c.trigger().finishedInAllMergingWindows()) {
                c.trigger().setFinished(false);
            } else if (!this.endOfWindowReached(c)) {
                c.trigger().setFinished(false);
            } else {
                c.trigger().setFinished(true);
            }
        }

        @Override
        public Instant getWatermarkThatGuaranteesFiring(W window) {
            return ((BoundedWindow)window).maxTimestamp();
        }

        @Override
        public FromEndOfWindow<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
            return this;
        }

        @Override
        public String toString() {
            return AfterWatermark.TO_STRING;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FromEndOfWindow;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getClass());
        }

        @Override
        public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
            return this.endOfWindowReached(context);
        }

        private boolean endOfWindowReached(Trigger.TriggerContext context) {
            return context.currentEventTime() != null && context.currentEventTime().isAfter((ReadableInstant)((BoundedWindow)context.window()).maxTimestamp());
        }

        @Override
        protected void onOnlyFiring(Trigger.TriggerContext context) throws Exception {
        }
    }

    private static class AfterWatermarkEarlyAndLate<W extends BoundedWindow>
    extends Trigger<W>
    implements TriggerBuilder<W>,
    AfterWatermarkEarly<W>,
    AfterWatermarkLate<W> {
        private static final int EARLY_INDEX = 0;
        private static final int LATE_INDEX = 1;
        private final Trigger.OnceTrigger<W> earlyTrigger;
        @Nullable
        private final Trigger.OnceTrigger<W> lateTrigger;

        private AfterWatermarkEarlyAndLate(Trigger.OnceTrigger<W> earlyTrigger, Trigger.OnceTrigger<W> lateTrigger) {
            super(lateTrigger == null ? ImmutableList.of(earlyTrigger) : ImmutableList.of(earlyTrigger, lateTrigger));
            this.earlyTrigger = Preconditions.checkNotNull(earlyTrigger, "earlyTrigger should not be null");
            this.lateTrigger = lateTrigger;
        }

        @Override
        public TriggerBuilder<W> withEarlyFirings(Trigger.OnceTrigger<W> earlyTrigger) {
            return new AfterWatermarkEarlyAndLate<W>(earlyTrigger, this.lateTrigger);
        }

        @Override
        public TriggerBuilder<W> withLateFirings(Trigger.OnceTrigger<W> lateTrigger) {
            return new AfterWatermarkEarlyAndLate<W>(this.earlyTrigger, lateTrigger);
        }

        @Override
        public void onElement(Trigger.OnElementContext c) throws Exception {
            if (!c.trigger().isMerging()) {
                c.trigger().firstUnfinishedSubTrigger().invokeOnElement(c);
            } else {
                for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
                    subTrigger.invokeOnElement(c);
                }
            }
        }

        @Override
        public void onMerge(Trigger.OnMergeContext c) throws Exception {
            ExecutableTrigger earlySubtrigger = c.trigger().subTrigger(0);
            Trigger.TriggerContext earlyContext = c.forTrigger(earlySubtrigger);
            if (!((Trigger.OnMergeContext)earlyContext).trigger().finishedInAllMergingWindows() || !this.endOfWindowReached(c)) {
                ((Trigger.OnMergeContext)earlyContext).trigger().setFinished(false);
                if (this.lateTrigger != null) {
                    ExecutableTrigger lateSubtrigger = c.trigger().subTrigger(1);
                    Trigger.TriggerContext lateContext = c.forTrigger(lateSubtrigger);
                    ((Trigger.OnMergeContext)lateContext).trigger().setFinished(false);
                    lateSubtrigger.invokeClear(lateContext);
                }
            } else {
                ((Trigger.OnMergeContext)earlyContext).trigger().setFinished(true);
                if (this.lateTrigger != null) {
                    c.trigger().subTrigger(1).invokeOnMerge(c);
                }
            }
        }

        @Override
        public Trigger<W> getContinuationTrigger() {
            return new AfterWatermarkEarlyAndLate<W>(this.earlyTrigger.getContinuationTrigger(), this.lateTrigger == null ? null : this.lateTrigger.getContinuationTrigger());
        }

        @Override
        protected Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
            throw new UnsupportedOperationException("Should not call getContinuationTrigger(List<Trigger<W>>)");
        }

        @Override
        public Instant getWatermarkThatGuaranteesFiring(W window) {
            return ((BoundedWindow)window).maxTimestamp();
        }

        private boolean endOfWindowReached(Trigger.TriggerContext context) {
            return context.currentEventTime() != null && context.currentEventTime().isAfter((ReadableInstant)((BoundedWindow)context.window()).maxTimestamp());
        }

        @Override
        public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
            if (!context.trigger().isFinished(0)) {
                return context.trigger().subTrigger(0).invokeShouldFire(context) || this.endOfWindowReached(context);
            }
            if (this.lateTrigger == null) {
                return false;
            }
            return context.trigger().subTrigger(1).invokeShouldFire(context);
        }

        @Override
        public void onFire(Trigger.TriggerContext context) throws Exception {
            if (!context.forTrigger(context.trigger().subTrigger(0)).trigger().isFinished()) {
                this.onNonLateFiring(context);
            } else if (this.lateTrigger != null) {
                this.onLateFiring(context);
            } else {
                context.trigger().setFinished(true);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(AfterWatermark.TO_STRING);
            if (!(this.earlyTrigger instanceof Never.NeverTrigger)) {
                builder.append(".withEarlyFirings(").append(this.earlyTrigger).append(")");
            }
            if (this.lateTrigger != null && !(this.lateTrigger instanceof Never.NeverTrigger)) {
                builder.append(".withLateFirings(").append(this.lateTrigger).append(")");
            }
            return builder.toString();
        }

        private void onNonLateFiring(Trigger.TriggerContext context) throws Exception {
            ExecutableTrigger earlySubtrigger = context.trigger().subTrigger(0);
            Trigger.TriggerContext earlyContext = context.forTrigger(earlySubtrigger);
            if (!this.endOfWindowReached(context)) {
                earlySubtrigger.invokeOnFire(context);
                earlySubtrigger.invokeClear(context);
                earlyContext.trigger().setFinished(false);
            } else {
                if (earlySubtrigger.invokeShouldFire(context)) {
                    earlySubtrigger.invokeOnFire(context);
                }
                earlyContext.trigger().setFinished(true);
                earlySubtrigger.invokeClear(context);
                if (this.lateTrigger == null) {
                    context.trigger().setFinished(true);
                } else {
                    context.trigger().subTrigger(1).invokeClear(context);
                }
            }
        }

        private void onLateFiring(Trigger.TriggerContext context) throws Exception {
            ExecutableTrigger lateSubtrigger = context.trigger().subTrigger(1);
            lateSubtrigger.invokeOnFire(context);
            lateSubtrigger.invokeClear(context);
            context.forTrigger(lateSubtrigger).trigger().setFinished(false);
        }
    }

    public static interface AfterWatermarkLate<W extends BoundedWindow>
    extends TriggerBuilder<W> {
        public TriggerBuilder<W> withEarlyFirings(Trigger.OnceTrigger<W> var1);
    }

    public static interface AfterWatermarkEarly<W extends BoundedWindow>
    extends TriggerBuilder<W> {
        public TriggerBuilder<W> withLateFirings(Trigger.OnceTrigger<W> var1);
    }
}

