/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.windowing.AfterDelayFromFirstElement;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.Instant;

class AfterSynchronizedProcessingTime<W extends BoundedWindow>
extends AfterDelayFromFirstElement<W> {
    @Override
    @Nullable
    public Instant getCurrentTime(Trigger.TriggerContext context) {
        return context.currentSynchronizedProcessingTime();
    }

    public AfterSynchronizedProcessingTime() {
        super(TimeDomain.SYNCHRONIZED_PROCESSING_TIME, Collections.emptyList());
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    protected Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return this;
    }

    @Override
    public String toString() {
        return "AfterSynchronizedProcessingTime.pastFirstElementInPane()";
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof AfterSynchronizedProcessingTime;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(AfterSynchronizedProcessingTime.class);
    }

    @Override
    protected AfterSynchronizedProcessingTime<W> newWith(List<SerializableFunction<Instant, Instant>> transforms) {
        return this;
    }
}

