/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.windowing.AfterDelayFromFirstElement;
import com.google.cloud.dataflow.sdk.transforms.windowing.AfterSynchronizedProcessingTime;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterProcessingTime<W extends BoundedWindow>
extends AfterDelayFromFirstElement<W> {
    @Override
    @Nullable
    public Instant getCurrentTime(Trigger.TriggerContext context) {
        return context.currentProcessingTime();
    }

    private AfterProcessingTime(List<SerializableFunction<Instant, Instant>> transforms) {
        super(TimeDomain.PROCESSING_TIME, transforms);
    }

    public static <W extends BoundedWindow> AfterProcessingTime<W> pastFirstElementInPane() {
        return new AfterProcessingTime<W>(IDENTITY);
    }

    @Override
    protected AfterProcessingTime<W> newWith(List<SerializableFunction<Instant, Instant>> transforms) {
        return new AfterProcessingTime<W>(transforms);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    protected Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return new AfterSynchronizedProcessingTime();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterProcessingTime.pastFirstElementInPane()");
        for (SerializableFunction delayFn : this.timestampMappers) {
            builder.append(".plusDelayOf(").append(delayFn).append(")");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterProcessingTime)) {
            return false;
        }
        AfterProcessingTime that = (AfterProcessingTime)obj;
        return Objects.equals(this.timestampMappers, that.timestampMappers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.timestampMappers);
    }
}

