/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.join;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.join.CoGbkResultSchema;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TupleTagList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KeyedPCollectionTuple<K>
implements PInput {
    private final List<TaggedKeyedPCollection<K, ?>> keyedCollections;
    private final Coder<K> keyCoder;
    private final CoGbkResultSchema schema;
    private final Pipeline pipeline;

    public static <K> KeyedPCollectionTuple<K> empty(Pipeline pipeline) {
        return new KeyedPCollectionTuple<K>(pipeline);
    }

    public static <K, InputT> KeyedPCollectionTuple<K> of(TupleTag<InputT> tag, PCollection<KV<K, InputT>> pc) {
        return new KeyedPCollectionTuple<K>(pc.getPipeline()).and(tag, pc);
    }

    public <V> KeyedPCollectionTuple<K> and(TupleTag<V> tag, PCollection<KV<K, V>> pc) {
        if (pc.getPipeline() != this.getPipeline()) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        TaggedKeyedPCollection<K, V> wrapper = new TaggedKeyedPCollection<K, V>(tag, pc);
        Coder<K> myKeyCoder = this.keyCoder == null ? KeyedPCollectionTuple.getKeyCoder(pc) : this.keyCoder;
        List<TaggedKeyedPCollection<K, ?>> newKeyedCollections = KeyedPCollectionTuple.copyAddLast(this.keyedCollections, wrapper);
        return new KeyedPCollectionTuple<K>(this.getPipeline(), newKeyedCollections, this.schema.getTupleTagList().and(tag), myKeyCoder);
    }

    public boolean isEmpty() {
        return this.keyedCollections.isEmpty();
    }

    public List<TaggedKeyedPCollection<K, ?>> getKeyedCollections() {
        return this.keyedCollections;
    }

    public <OutputT extends POutput> OutputT apply(PTransform<KeyedPCollectionTuple<K>, OutputT> transform) {
        return Pipeline.applyTransform(this, transform);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<KeyedPCollectionTuple<K>, OutputT> transform) {
        return Pipeline.applyTransform(name, this, transform);
    }

    @Override
    public Collection<? extends PValue> expand() {
        ArrayList retval = new ArrayList();
        for (TaggedKeyedPCollection<K, ?> taggedPCollection : this.keyedCollections) {
            retval.add(taggedPCollection.pCollection);
        }
        return retval;
    }

    public Coder<K> getKeyCoder() {
        if (this.keyCoder == null) {
            throw new IllegalStateException("cannot return null keyCoder");
        }
        return this.keyCoder;
    }

    public CoGbkResultSchema getCoGbkResultSchema() {
        return this.schema;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public void finishSpecifying() {
        for (TaggedKeyedPCollection<K, ?> taggedPCollection : this.keyedCollections) {
            taggedPCollection.pCollection.finishSpecifying();
        }
    }

    KeyedPCollectionTuple(Pipeline pipeline) {
        this(pipeline, new ArrayList(), TupleTagList.empty(), null);
    }

    KeyedPCollectionTuple(Pipeline pipeline, List<TaggedKeyedPCollection<K, ?>> keyedCollections, TupleTagList tupleTagList, Coder<K> keyCoder) {
        this.pipeline = pipeline;
        this.keyedCollections = keyedCollections;
        this.schema = new CoGbkResultSchema(tupleTagList);
        this.keyCoder = keyCoder;
    }

    private static <K, V> Coder<K> getKeyCoder(PCollection<KV<K, V>> pc) {
        pc.finishSpecifying();
        Coder<KV<K, V>> entryCoder = pc.getCoder();
        if (!(entryCoder instanceof KvCoder)) {
            throw new IllegalArgumentException("PCollection does not use a KvCoder");
        }
        KvCoder coder = (KvCoder)entryCoder;
        return coder.getKeyCoder();
    }

    private static <K> List<TaggedKeyedPCollection<K, ?>> copyAddLast(List<TaggedKeyedPCollection<K, ?>> keyedCollections, TaggedKeyedPCollection<K, ?> taggedCollection) {
        ArrayList retval = new ArrayList(keyedCollections);
        retval.add(taggedCollection);
        return retval;
    }

    public static class TaggedKeyedPCollection<K, V> {
        final TupleTag<V> tupleTag;
        final PCollection<KV<K, V>> pCollection;

        public TaggedKeyedPCollection(TupleTag<V> tupleTag, PCollection<KV<K, V>> pCollection) {
            this.tupleTag = tupleTag;
            this.pCollection = pCollection;
        }

        public PCollection<KV<K, V>> getCollection() {
            return this.pCollection;
        }

        public TupleTag<V> getTupleTag() {
            return this.tupleTag;
        }
    }
}

