/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.display;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Sets;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.reflect.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DisplayData
implements Serializable {
    private static final DisplayData EMPTY = new DisplayData(Maps.newHashMap());
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final ImmutableMap<Identifier, Item<?>> entries;

    private DisplayData(Map<Identifier, Item<?>> entries) {
        this.entries = ImmutableMap.copyOf(entries);
    }

    public static DisplayData none() {
        return EMPTY;
    }

    public static DisplayData from(HasDisplayData component) {
        Preconditions.checkNotNull(component, "component argument cannot be null");
        return InternalBuilder.forRoot(component).build();
    }

    @Nullable
    public static Type inferType(@Nullable Object value) {
        return Type.tryInferFrom(value);
    }

    @JsonValue
    public Collection<Item<?>> items() {
        return this.entries.values();
    }

    public Map<Identifier, Item<?>> asMap() {
        return this.entries;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DisplayData) {
            DisplayData that = (DisplayData)obj;
            return Objects.equals(this.entries, that.entries);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean isFirstLine = true;
        for (Item entry : this.entries.values()) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                builder.append("\n");
            }
            builder.append(entry);
        }
        return builder.toString();
    }

    private static String namespaceOf(Class<?> clazz) {
        return clazz.getName();
    }

    public static Item<String> item(String key, @Nullable String value) {
        return DisplayData.item(key, Type.STRING, value);
    }

    public static Item<Integer> item(String key, @Nullable Integer value) {
        return DisplayData.item(key, Type.INTEGER, value);
    }

    public static Item<Long> item(String key, @Nullable Long value) {
        return DisplayData.item(key, Type.INTEGER, value);
    }

    public static Item<Float> item(String key, @Nullable Float value) {
        return DisplayData.item(key, Type.FLOAT, value);
    }

    public static Item<Double> item(String key, @Nullable Double value) {
        return DisplayData.item(key, Type.FLOAT, value);
    }

    public static Item<Boolean> item(String key, @Nullable Boolean value) {
        return DisplayData.item(key, Type.BOOLEAN, value);
    }

    public static Item<Instant> item(String key, @Nullable Instant value) {
        return DisplayData.item(key, Type.TIMESTAMP, value);
    }

    public static Item<Duration> item(String key, @Nullable Duration value) {
        return DisplayData.item(key, Type.DURATION, value);
    }

    public static <T> Item<Class<T>> item(String key, @Nullable Class<T> value) {
        return DisplayData.item(key, Type.JAVA_CLASS, value);
    }

    public static <T> Item<T> item(String key, Type type, @Nullable T value) {
        Preconditions.checkNotNull(key, "key argument cannot be null");
        Preconditions.checkNotNull(type, "type argument cannot be null");
        return Item.create(key, type, value);
    }

    private static class InternalBuilder
    implements Builder {
        private final Map<Identifier, Item<?>> entries = Maps.newHashMap();
        private final Set<Object> visited = Sets.newIdentityHashSet();
        private String latestNs;

        private InternalBuilder() {
        }

        private static InternalBuilder forRoot(HasDisplayData instance) {
            InternalBuilder builder = new InternalBuilder();
            builder.include(instance);
            return builder;
        }

        @Override
        public Builder include(HasDisplayData subComponent) {
            Preconditions.checkNotNull(subComponent, "subComponent argument cannot be null");
            return this.include(subComponent, subComponent.getClass());
        }

        @Override
        public Builder include(HasDisplayData subComponent, Class<?> namespace) {
            Preconditions.checkNotNull(namespace, "Input namespace override cannot be null");
            return this.include(subComponent, DisplayData.namespaceOf(namespace));
        }

        @Override
        public Builder include(HasDisplayData subComponent, String namespace) {
            Preconditions.checkNotNull(subComponent, "subComponent argument cannot be null");
            Preconditions.checkNotNull(namespace, "Input namespace override cannot be null");
            boolean newComponent = this.visited.add(subComponent);
            if (newComponent) {
                String prevNs = this.latestNs;
                this.latestNs = namespace;
                try {
                    subComponent.populateDisplayData(this);
                }
                catch (PopulateDisplayDataException e) {
                    throw e;
                }
                catch (Throwable e) {
                    String msg = String.format("Error while populating display data for component: %s", namespace);
                    throw new PopulateDisplayDataException(msg, e);
                }
                this.latestNs = prevNs;
            }
            return this;
        }

        @Override
        public Builder add(Item<?> item) {
            Preconditions.checkNotNull(item, "Input display item cannot be null");
            return this.addItemIf(true, item);
        }

        @Override
        public Builder addIfNotNull(Item<?> item) {
            Preconditions.checkNotNull(item, "Input display item cannot be null");
            return this.addItemIf(item.getValue() != null, item);
        }

        @Override
        public <T> Builder addIfNotDefault(Item<T> item, @Nullable T defaultValue) {
            Preconditions.checkNotNull(item, "Input display item cannot be null");
            Item defaultItem = ((Item)item).withValue(defaultValue);
            return this.addItemIf(!Objects.equals(item, defaultItem), item);
        }

        private Builder addItemIf(boolean condition, Item<?> item) {
            Identifier id;
            if (!condition) {
                return this;
            }
            Preconditions.checkNotNull(item, "Input display item cannot be null");
            Preconditions.checkNotNull(item.getValue(), "Input display value cannot be null");
            if (item.getNamespace() == null) {
                item = item.withNamespace(this.latestNs);
            }
            Preconditions.checkArgument(!this.entries.containsKey(id = Identifier.of(item.getNamespace(), item.getKey())), "Display data key (%s) is not unique within the specified namespace (%s).", item.getKey(), item.getNamespace());
            this.entries.put(id, item);
            return this;
        }

        private DisplayData build() {
            return new DisplayData(this.entries);
        }

        private class PopulateDisplayDataException
        extends RuntimeException {
            PopulateDisplayDataException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    static class FormattedItemValue {
        private static final FormattedItemValue NULL_VALUES = new FormattedItemValue(null);
        private final Object shortValue;
        private final Object longValue;

        private FormattedItemValue(Object longValue) {
            this(longValue, (Object)null);
        }

        private FormattedItemValue(Object longValue, Object shortValue) {
            this.longValue = longValue;
            this.shortValue = shortValue;
        }

        Object getLongValue() {
            return this.longValue;
        }

        Object getShortValue() {
            return this.shortValue;
        }
    }

    public static enum Type {
        STRING{

            @Override
            FormattedItemValue format(Object value) {
                return new FormattedItemValue(Type.checkType(value, String.class, 1.STRING));
            }
        }
        ,
        INTEGER{

            @Override
            FormattedItemValue format(Object value) {
                if (value instanceof Integer) {
                    long l = ((Integer)value).longValue();
                    return this.format(l);
                }
                return new FormattedItemValue(Type.checkType(value, Long.class, 2.INTEGER));
            }
        }
        ,
        FLOAT{

            @Override
            FormattedItemValue format(Object value) {
                return new FormattedItemValue(Type.checkType(value, Number.class, 3.FLOAT));
            }
        }
        ,
        BOOLEAN{

            @Override
            FormattedItemValue format(Object value) {
                return new FormattedItemValue(Type.checkType(value, Boolean.class, 4.BOOLEAN));
            }
        }
        ,
        TIMESTAMP{

            @Override
            FormattedItemValue format(Object value) {
                Instant instant = (Instant)Type.checkType(value, Instant.class, 5.TIMESTAMP);
                return new FormattedItemValue((Object)TIMESTAMP_FORMATTER.print((ReadableInstant)instant));
            }
        }
        ,
        DURATION{

            @Override
            FormattedItemValue format(Object value) {
                Duration duration = (Duration)Type.checkType(value, Duration.class, 6.DURATION);
                return new FormattedItemValue((Object)duration.getMillis());
            }
        }
        ,
        JAVA_CLASS{

            @Override
            FormattedItemValue format(Object value) {
                Class clazz = (Class)Type.checkType(value, Class.class, 7.JAVA_CLASS);
                return new FormattedItemValue(clazz.getName(), clazz.getSimpleName());
            }
        };


        private static <T> T checkType(Object value, Class<T> clazz, Type expectedType) {
            if (!clazz.isAssignableFrom(value.getClass())) {
                throw new ClassCastException(String.format("Value is not valid for DisplayData type %s: %s", new Object[]{expectedType, value}));
            }
            Object typedValue = value;
            return (T)typedValue;
        }

        abstract FormattedItemValue format(Object var1);

        FormattedItemValue safeFormat(@Nullable Object value) {
            if (value == null) {
                return FormattedItemValue.NULL_VALUES;
            }
            return this.format(value);
        }

        @Nullable
        private static Type tryInferFrom(@Nullable Object value) {
            if (value instanceof Integer || value instanceof Long) {
                return INTEGER;
            }
            if (value instanceof Double || value instanceof Float) {
                return FLOAT;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Instant) {
                return TIMESTAMP;
            }
            if (value instanceof Duration) {
                return DURATION;
            }
            if (value instanceof Class) {
                return JAVA_CLASS;
            }
            if (value instanceof String) {
                return STRING;
            }
            return null;
        }
    }

    public static class Identifier {
        private final String ns;
        private final String key;

        public static Identifier of(Class<?> namespace, String key) {
            return Identifier.of(DisplayData.namespaceOf(namespace), key);
        }

        public static Identifier of(String namespace, String key) {
            return new Identifier(namespace, key);
        }

        private Identifier(String ns, String key) {
            this.ns = ns;
            this.key = key;
        }

        public String getNamespace() {
            return this.ns;
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Identifier) {
                Identifier that = (Identifier)obj;
                return Objects.equals(this.ns, that.ns) && Objects.equals(this.key, that.key);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.ns, this.key);
        }

        public String toString() {
            return String.format("%s:%s", this.ns, this.key);
        }
    }

    public static final class Item<T>
    implements Serializable {
        @Nullable
        private final String namespace;
        private final String key;
        private final Type type;
        @Nullable
        private final Object value;
        @Nullable
        private final Object shortValue;
        @Nullable
        private final String label;
        @Nullable
        private final String linkUrl;

        @Nullable
        @JsonGetter(value="namespace")
        public String getNamespace() {
            return this.namespace;
        }

        @JsonGetter(value="key")
        public String getKey() {
            return this.key;
        }

        @JsonGetter(value="type")
        public Type getType() {
            return this.type;
        }

        @JsonGetter(value="value")
        @Nullable
        public Object getValue() {
            return this.value;
        }

        @JsonGetter(value="shortValue")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Object getShortValue() {
            return this.shortValue;
        }

        @JsonGetter(value="label")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        public String getLabel() {
            return this.label;
        }

        @JsonGetter(value="linkUrl")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        public String getLinkUrl() {
            return this.linkUrl;
        }

        private static <T> Item<T> create(String key, Type type, @Nullable T value) {
            FormattedItemValue formatted = type.safeFormat(value);
            return new Item<T>(null, key, type, formatted.getLongValue(), formatted.getShortValue(), null, null);
        }

        public Item<T> withNamespace(Class<?> namespace) {
            Preconditions.checkNotNull(namespace, "namespace argument cannot be null");
            return this.withNamespace(DisplayData.namespaceOf(namespace));
        }

        public Item<T> withNamespace(String namespace) {
            Preconditions.checkNotNull(namespace, "namespace argument cannot be null");
            return new Item<T>(namespace, this.getKey(), this.getType(), this.getValue(), this.getShortValue(), this.getLabel(), this.getLinkUrl());
        }

        public Item<T> withLabel(String label) {
            return new Item<T>(this.getNamespace(), this.getKey(), this.getType(), this.getValue(), this.getShortValue(), label, this.getLinkUrl());
        }

        public Item<T> withLinkUrl(String url) {
            return new Item<T>(this.getNamespace(), this.getKey(), this.getType(), this.getValue(), this.getShortValue(), this.getLabel(), url);
        }

        private Item<T> withValue(Object value) {
            FormattedItemValue formatted = this.getType().safeFormat(value);
            return new Item<T>(this.getNamespace(), this.getKey(), this.getType(), formatted.getLongValue(), formatted.getShortValue(), this.getLabel(), this.getLinkUrl());
        }

        private Item(@Nullable String namespace, String key, Type type, @Nullable Object value, @Nullable Object shortValue, @Nullable String label, @Nullable String linkUrl) {
            this.namespace = namespace;
            this.key = Preconditions.checkNotNull(key);
            this.type = Preconditions.checkNotNull(type);
            this.value = value;
            this.shortValue = shortValue;
            this.label = label;
            this.linkUrl = linkUrl;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.namespace, this.key, this.type, this.value, this.shortValue, this.label, this.linkUrl});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Item)) {
                return false;
            }
            Item that = (Item)obj;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.key, that.key) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.value, that.value) && Objects.equals(this.shortValue, that.shortValue) && Objects.equals(this.label, that.label) && Objects.equals(this.linkUrl, that.linkUrl);
        }

        public String toString() {
            return String.format("%s:%s=%s", this.getNamespace(), this.getKey(), this.getValue());
        }
    }

    public static interface Builder {
        public Builder include(HasDisplayData var1);

        public Builder include(HasDisplayData var1, Class<?> var2);

        public Builder include(HasDisplayData var1, String var2);

        public Builder add(Item<?> var1);

        public Builder addIfNotNull(Item<?> var1);

        public <T> Builder addIfNotDefault(Item<T> var1, @Nullable T var2);
    }
}

