/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionList;
import com.google.cloud.dataflow.sdk.values.PCollectionTuple;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TupleTagList;
import java.io.Serializable;
import java.util.Iterator;

public class Partition<T>
extends PTransform<PCollection<T>, PCollectionList<T>> {
    private final transient PartitionDoFn<T> partitionDoFn;

    public static <T> Partition<T> of(int numPartitions, PartitionFn<? super T> partitionFn) {
        return new Partition<T>(new PartitionDoFn<T>(numPartitions, partitionFn));
    }

    @Override
    public PCollectionList<T> apply(PCollection<T> in) {
        TupleTagList outputTags = this.partitionDoFn.getOutputTags();
        PCollectionTuple outputs = (PCollectionTuple)((Object)in.apply(ParDo.withOutputTags(new TupleTag<Void>(){}, outputTags).of(this.partitionDoFn)));
        PCollectionList pcs = PCollectionList.empty(in.getPipeline());
        Coder<T> coder = in.getCoder();
        Iterator<TupleTag<?>> iterator = outputTags.getAll().iterator();
        while (iterator.hasNext()) {
            TupleTag<?> outputTag;
            TupleTag<?> typedOutputTag = outputTag = iterator.next();
            pcs = pcs.and(outputs.get(typedOutputTag).setCoder((Coder)coder));
        }
        return pcs;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.include(this.partitionDoFn);
    }

    private Partition(PartitionDoFn<T> partitionDoFn) {
        this.partitionDoFn = partitionDoFn;
    }

    private static class PartitionDoFn<X>
    extends DoFn<X, Void> {
        private final int numPartitions;
        private final PartitionFn<? super X> partitionFn;
        private final TupleTagList outputTags;

        public PartitionDoFn(int numPartitions, PartitionFn<? super X> partitionFn) {
            if (numPartitions <= 0) {
                throw new IllegalArgumentException("numPartitions must be > 0");
            }
            this.numPartitions = numPartitions;
            this.partitionFn = partitionFn;
            TupleTagList buildOutputTags = TupleTagList.empty();
            for (int partition = 0; partition < numPartitions; ++partition) {
                buildOutputTags = buildOutputTags.and(new TupleTag());
            }
            this.outputTags = buildOutputTags;
        }

        public TupleTagList getOutputTags() {
            return this.outputTags;
        }

        @Override
        public void processElement(DoFn.ProcessContext c) {
            Object input = c.element();
            int partition = this.partitionFn.partitionFor(input, this.numPartitions);
            if (0 > partition || partition >= this.numPartitions) {
                throw new IndexOutOfBoundsException("Partition function returned out of bounds index: " + partition + " not in [0.." + this.numPartitions + ")");
            }
            TupleTag<?> typedTag = this.outputTags.get(partition);
            c.sideOutput(typedTag, input);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numPartitions", this.numPartitions).withLabel("Partition Count")).add(DisplayData.item("partitionFn", this.partitionFn.getClass()).withLabel("Partition Function"));
        }
    }

    public static interface PartitionFn<T>
    extends Serializable {
        public int partitionFor(T var1, int var2);
    }
}

