/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.TypedPValue;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class PTransform<InputT extends PInput, OutputT extends POutput>
implements Serializable,
HasDisplayData {
    protected final transient String name;

    public OutputT apply(InputT input) {
        throw new IllegalArgumentException("Runner " + input.getPipeline().getRunner() + " has not registered an implementation for the required primitive operation " + this);
    }

    public void validate(InputT input) {
    }

    public String getName() {
        return this.name != null ? this.name : this.getKindString();
    }

    protected PTransform() {
        this.name = null;
    }

    protected PTransform(String name) {
        this.name = name;
    }

    public String toString() {
        if (this.name == null) {
            return this.getKindString();
        }
        return this.getName() + " [" + this.getKindString() + "]";
    }

    protected String getKindString() {
        if (this.getClass().isAnonymousClass()) {
            return "AnonymousTransform";
        }
        return StringUtils.approximatePTransformName(this.getClass());
    }

    private void writeObject(ObjectOutputStream oos) {
    }

    private void readObject(ObjectInputStream oos) {
    }

    protected Coder<?> getDefaultOutputCoder() throws CannotProvideCoderException {
        throw new CannotProvideCoderException("PTransform.getDefaultOutputCoder called.");
    }

    protected Coder<?> getDefaultOutputCoder(InputT input) throws CannotProvideCoderException {
        return this.getDefaultOutputCoder();
    }

    public <T> Coder<T> getDefaultOutputCoder(InputT input, TypedPValue<T> output) throws CannotProvideCoderException {
        Coder<?> defaultOutputCoder = this.getDefaultOutputCoder(input);
        return defaultOutputCoder;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
    }
}

