/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.Top;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterProvider;
import java.io.Serializable;
import java.util.Comparator;

public class Min {
    private Min() {
    }

    public static Combine.Globally<Integer, Integer> integersGlobally() {
        return Combine.globally(new MinIntegerFn()).named("Min.Globally");
    }

    public static <K> Combine.PerKey<K, Integer, Integer> integersPerKey() {
        return Combine.perKey(new MinIntegerFn()).named("Min.PerKey");
    }

    public static Combine.Globally<Long, Long> longsGlobally() {
        return Combine.globally(new MinLongFn()).named("Min.Globally");
    }

    public static <K> Combine.PerKey<K, Long, Long> longsPerKey() {
        return Combine.perKey(new MinLongFn()).named("Min.PerKey");
    }

    public static Combine.Globally<Double, Double> doublesGlobally() {
        return Combine.globally(new MinDoubleFn()).named("Min.Globally");
    }

    public static <K> Combine.PerKey<K, Double, Double> doublesPerKey() {
        return Combine.perKey(new MinDoubleFn()).named("Min.PerKey");
    }

    public static <T extends Comparable<? super T>> Combine.Globally<T, T> globally() {
        return Combine.globally(MinFn.naturalOrder()).named("Min.Globally");
    }

    public static <K, T extends Comparable<? super T>> Combine.PerKey<K, T, T> perKey() {
        return Combine.perKey(MinFn.naturalOrder()).named("Min.PerKey");
    }

    public static <T, ComparatorT extends Comparator<? super T> & Serializable> Combine.Globally<T, T> globally(ComparatorT comparator) {
        return Combine.globally(MinFn.of(comparator)).named("Min.Globally");
    }

    public static <K, T, ComparatorT extends Comparator<? super T> & Serializable> Combine.PerKey<K, T, T> perKey(ComparatorT comparator) {
        return Combine.perKey(MinFn.of(comparator)).named("Min.PerKey");
    }

    public static class MinDoubleFn
    extends MinFn<Double>
    implements CounterProvider<Double> {
        public MinDoubleFn() {
            super(Double.POSITIVE_INFINITY, new Top.Largest(), null);
        }

        @Override
        public Counter<Double> getCounter(String name) {
            return Counter.doubles(name, Counter.AggregationKind.MIN);
        }
    }

    public static class MinLongFn
    extends MinFn<Long>
    implements CounterProvider<Long> {
        public MinLongFn() {
            super(Long.MAX_VALUE, new Top.Largest(), null);
        }

        @Override
        public Counter<Long> getCounter(String name) {
            return Counter.longs(name, Counter.AggregationKind.MIN);
        }
    }

    public static class MinIntegerFn
    extends MinFn<Integer>
    implements CounterProvider<Integer> {
        public MinIntegerFn() {
            super(Integer.MAX_VALUE, new Top.Largest(), null);
        }

        @Override
        public Counter<Integer> getCounter(String name) {
            return Counter.ints(name, Counter.AggregationKind.MIN);
        }
    }

    public static class MinFn<T>
    extends Combine.BinaryCombineFn<T> {
        private final T identity;
        private final Comparator<? super T> comparator;

        private <ComparatorT extends Comparator<? super T> & Serializable> MinFn(T identity, ComparatorT comparator) {
            this.identity = identity;
            this.comparator = comparator;
        }

        public static <T, ComparatorT extends Comparator<? super T> & Serializable> MinFn<T> of(T identity, ComparatorT comparator) {
            return new MinFn<T>(identity, comparator);
        }

        public static <T, ComparatorT extends Comparator<? super T> & Serializable> MinFn<T> of(ComparatorT comparator) {
            return new MinFn<Object>(null, comparator);
        }

        public static <T extends Comparable<? super T>> MinFn<T> naturalOrder(T identity) {
            return new MinFn<T>(identity, new Top.Largest());
        }

        public static <T extends Comparable<? super T>> MinFn<T> naturalOrder() {
            return new MinFn<Object>(null, new Top.Largest());
        }

        @Override
        public T identity() {
            return this.identity;
        }

        @Override
        public T apply(T left, T right) {
            return this.comparator.compare(left, right) <= 0 ? left : right;
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("comparer", this.comparator.getClass()).withLabel("Record Comparer"));
        }

        /* synthetic */ MinFn(Object x0, Comparator x1, 1 x2) {
            this(x0, x1);
        }
    }
}

