/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;

public class Count {
    private Count() {
    }

    public static <T> Combine.Globally<T, Long> globally() {
        return Combine.globally(new CountFn()).named("Count.Globally");
    }

    public static <K, V> Combine.PerKey<K, V, Long> perKey() {
        return Combine.perKey(new CountFn()).named("Count.PerKey");
    }

    public static <T> PerElement<T> perElement() {
        return new PerElement();
    }

    private static class CountFn<T>
    extends Combine.CombineFn<T, Long, Long> {
        private CountFn() {
        }

        @Override
        public Long createAccumulator() {
            return 0L;
        }

        @Override
        public Long addInput(Long accumulator, T input) {
            return accumulator + 1L;
        }

        @Override
        public Long mergeAccumulators(Iterable<Long> accumulators) {
            long result = 0L;
            for (Long accum : accumulators) {
                result += accum.longValue();
            }
            return result;
        }

        @Override
        public Long extractOutput(Long accumulator) {
            return accumulator;
        }
    }

    public static class PerElement<T>
    extends PTransform<PCollection<T>, PCollection<KV<T, Long>>> {
        @Override
        public PCollection<KV<T, Long>> apply(PCollection<T> input) {
            return (PCollection)((PCollection)input.apply(ParDo.named("Init").of(new DoFn<T, KV<T, Void>>(){

                @Override
                public void processElement(DoFn.ProcessContext c) {
                    c.output(KV.of(c.element(), null));
                }
            }))).apply(Count.perKey());
        }
    }
}

