/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.transforms.CombineFnBase;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.values.PCollectionView;

public class CombineWithContext {

    public static abstract class KeyedCombineFnWithContext<K, InputT, AccumT, OutputT>
    extends CombineFnBase.AbstractPerKeyCombineFn<K, InputT, AccumT, OutputT>
    implements RequiresContextInternal {
        public abstract AccumT createAccumulator(K var1, Context var2);

        public abstract AccumT addInput(K var1, AccumT var2, InputT var3, Context var4);

        public abstract AccumT mergeAccumulators(K var1, Iterable<AccumT> var2, Context var3);

        public abstract OutputT extractOutput(K var1, AccumT var2, Context var3);

        public AccumT compact(K key, AccumT accumulator, Context c) {
            return accumulator;
        }

        public OutputT apply(K key, Iterable<? extends InputT> inputs, Context c) {
            AccumT accum = this.createAccumulator(key, c);
            for (InputT input : inputs) {
                accum = this.addInput(key, accum, input, c);
            }
            return this.extractOutput(key, accum, c);
        }

        @Override
        public CombineFnWithContext<InputT, AccumT, OutputT> forKey(final K key, final Coder<K> keyCoder) {
            return new CombineFnWithContext<InputT, AccumT, OutputT>(){

                @Override
                public AccumT createAccumulator(Context c) {
                    return KeyedCombineFnWithContext.this.createAccumulator(key, c);
                }

                @Override
                public AccumT addInput(AccumT accumulator, InputT input, Context c) {
                    return KeyedCombineFnWithContext.this.addInput(key, accumulator, input, c);
                }

                @Override
                public AccumT mergeAccumulators(Iterable<AccumT> accumulators, Context c) {
                    return KeyedCombineFnWithContext.this.mergeAccumulators(key, accumulators, c);
                }

                @Override
                public OutputT extractOutput(AccumT accumulator, Context c) {
                    return KeyedCombineFnWithContext.this.extractOutput(key, accumulator, c);
                }

                @Override
                public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return KeyedCombineFnWithContext.this.getAccumulatorCoder(registry, keyCoder, inputCoder);
                }

                @Override
                public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return KeyedCombineFnWithContext.this.getDefaultOutputCoder(registry, keyCoder, inputCoder);
                }
            };
        }
    }

    public static abstract class CombineFnWithContext<InputT, AccumT, OutputT>
    extends CombineFnBase.AbstractGlobalCombineFn<InputT, AccumT, OutputT>
    implements RequiresContextInternal {
        public abstract AccumT createAccumulator(Context var1);

        public abstract AccumT addInput(AccumT var1, InputT var2, Context var3);

        public abstract AccumT mergeAccumulators(Iterable<AccumT> var1, Context var2);

        public abstract OutputT extractOutput(AccumT var1, Context var2);

        public AccumT compact(AccumT accumulator, Context c) {
            return accumulator;
        }

        @Override
        public OutputT defaultValue() {
            throw new UnsupportedOperationException("Override this function to provide the default value.");
        }

        @Override
        public <K> KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> asKeyedFn() {
            return new KeyedCombineFnWithContext<K, InputT, AccumT, OutputT>(){

                @Override
                public AccumT createAccumulator(K key, Context c) {
                    return CombineFnWithContext.this.createAccumulator(c);
                }

                @Override
                public AccumT addInput(K key, AccumT accumulator, InputT input, Context c) {
                    return CombineFnWithContext.this.addInput(accumulator, input, c);
                }

                @Override
                public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators, Context c) {
                    return CombineFnWithContext.this.mergeAccumulators(accumulators, c);
                }

                @Override
                public OutputT extractOutput(K key, AccumT accumulator, Context c) {
                    return CombineFnWithContext.this.extractOutput(accumulator, c);
                }

                @Override
                public AccumT compact(K key, AccumT accumulator, Context c) {
                    return CombineFnWithContext.this.compact(accumulator, c);
                }

                @Override
                public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return CombineFnWithContext.this.getAccumulatorCoder(registry, inputCoder);
                }

                @Override
                public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                    return CombineFnWithContext.this.getDefaultOutputCoder(registry, inputCoder);
                }

                @Override
                public CombineFnWithContext<InputT, AccumT, OutputT> forKey(K key, Coder<K> keyCoder) {
                    return CombineFnWithContext.this;
                }

                @Override
                public void populateDisplayData(DisplayData.Builder builder) {
                    super.populateDisplayData(builder);
                    CombineFnWithContext.this.populateDisplayData(builder);
                }
            };
        }
    }

    public static interface RequiresContextInternal {
    }

    public static abstract class Context {
        public abstract PipelineOptions getPipelineOptions();

        public abstract <T> T sideInput(PCollectionView<T> var1);
    }
}

