/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.Serializable;
import java.lang.reflect.TypeVariable;

public class CombineFnBase {

    static abstract class AbstractPerKeyCombineFn<K, InputT, AccumT, OutputT>
    implements PerKeyCombineFn<K, InputT, AccumT, OutputT> {
        AbstractPerKeyCombineFn() {
        }

        @Override
        public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getDefaultCoder(this.getClass(), AbstractPerKeyCombineFn.class, ImmutableMap.of(this.getKTypeVariable(), keyCoder, this.getInputTVariable(), inputCoder), this.getAccumTVariable());
        }

        @Override
        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getDefaultCoder(this.getClass(), AbstractPerKeyCombineFn.class, ImmutableMap.of(this.getKTypeVariable(), keyCoder, this.getInputTVariable(), inputCoder, this.getAccumTVariable(), this.getAccumulatorCoder(registry, keyCoder, inputCoder)), this.getOutputTVariable());
        }

        public TypeVariable<?> getKTypeVariable() {
            return (TypeVariable)new TypeDescriptor<K>(AbstractPerKeyCombineFn.class){}.getType();
        }

        public TypeVariable<?> getInputTVariable() {
            return (TypeVariable)new TypeDescriptor<InputT>(AbstractPerKeyCombineFn.class){}.getType();
        }

        public TypeVariable<?> getAccumTVariable() {
            return (TypeVariable)new TypeDescriptor<AccumT>(AbstractPerKeyCombineFn.class){}.getType();
        }

        public TypeVariable<?> getOutputTVariable() {
            return (TypeVariable)new TypeDescriptor<OutputT>(AbstractPerKeyCombineFn.class){}.getType();
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
        }
    }

    static abstract class AbstractGlobalCombineFn<InputT, AccumT, OutputT>
    implements GlobalCombineFn<InputT, AccumT, OutputT>,
    Serializable {
        private static final String INCOMPATIBLE_GLOBAL_WINDOW_ERROR_MESSAGE = "Default values are not supported in Combine.globally() if the output PCollection is not windowed by GlobalWindows. Instead, use Combine.globally().withoutDefaults() to output an empty PCollection if the input PCollection is empty, or Combine.globally().asSingletonView() to get the default output of the CombineFn if the input PCollection is empty.";

        AbstractGlobalCombineFn() {
        }

        @Override
        public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getDefaultCoder(this.getClass(), AbstractGlobalCombineFn.class, ImmutableMap.of(this.getInputTVariable(), inputCoder), this.getAccumTVariable());
        }

        @Override
        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getDefaultCoder(this.getClass(), AbstractGlobalCombineFn.class, ImmutableMap.of(this.getInputTVariable(), inputCoder, this.getAccumTVariable(), this.getAccumulatorCoder(registry, inputCoder)), this.getOutputTVariable());
        }

        @Override
        public String getIncompatibleGlobalWindowErrorMessage() {
            return INCOMPATIBLE_GLOBAL_WINDOW_ERROR_MESSAGE;
        }

        public TypeVariable<?> getInputTVariable() {
            return (TypeVariable)new TypeDescriptor<InputT>(AbstractGlobalCombineFn.class){}.getType();
        }

        public TypeVariable<?> getAccumTVariable() {
            return (TypeVariable)new TypeDescriptor<AccumT>(AbstractGlobalCombineFn.class){}.getType();
        }

        public TypeVariable<?> getOutputTVariable() {
            return (TypeVariable)new TypeDescriptor<OutputT>(AbstractGlobalCombineFn.class){}.getType();
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
        }
    }

    public static interface PerKeyCombineFn<K, InputT, AccumT, OutputT>
    extends Serializable,
    HasDisplayData {
        public Coder<AccumT> getAccumulatorCoder(CoderRegistry var1, Coder<K> var2, Coder<InputT> var3) throws CannotProvideCoderException;

        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry var1, Coder<K> var2, Coder<InputT> var3) throws CannotProvideCoderException;

        public GlobalCombineFn<InputT, AccumT, OutputT> forKey(K var1, Coder<K> var2);
    }

    public static interface GlobalCombineFn<InputT, AccumT, OutputT>
    extends Serializable,
    HasDisplayData {
        public Coder<AccumT> getAccumulatorCoder(CoderRegistry var1, Coder<InputT> var2) throws CannotProvideCoderException;

        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry var1, Coder<InputT> var2) throws CannotProvideCoderException;

        public String getIncompatibleGlobalWindowErrorMessage();

        public OutputT defaultValue();

        public <K> PerKeyCombineFn<K, InputT, AccumT, OutputT> asKeyedFn();
    }
}

