/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.SerializableCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.hash.Hashing;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.hash.HashingOutputStream;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.ByteStreams;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.avro.reflect.Nullable;

public class ApproximateUnique {
    public static <T> Globally<T> globally(int sampleSize) {
        return new Globally(sampleSize);
    }

    public static <T> Globally<T> globally(double maximumEstimationError) {
        return new Globally(maximumEstimationError);
    }

    public static <K, V> PerKey<K, V> perKey(int sampleSize) {
        return new PerKey(sampleSize);
    }

    public static <K, V> PerKey<K, V> perKey(double maximumEstimationError) {
        return new PerKey(maximumEstimationError);
    }

    static long sampleSizeFromEstimationError(double estimationError) {
        return Math.round(Math.ceil(4.0 / Math.pow(estimationError, 2.0)));
    }

    private static void populateDisplayData(DisplayData.Builder builder, long sampleSize, Double maxEstimationError) {
        builder.add(DisplayData.item("sampleSize", sampleSize).withLabel("Sample Size")).addIfNotNull(DisplayData.item("maximumEstimationError", maxEstimationError).withLabel("Maximum Estimation Error"));
    }

    public static class ApproximateUniqueCombineFn<T>
    extends Combine.CombineFn<T, LargestUnique, Long> {
        static final double HASH_SPACE_SIZE = 1.8446744073709552E19;
        private final long sampleSize;
        private final Coder<T> coder;

        public ApproximateUniqueCombineFn(long sampleSize, Coder<T> coder) {
            this.sampleSize = sampleSize;
            this.coder = coder;
        }

        @Override
        public LargestUnique createAccumulator() {
            return new LargestUnique(this.sampleSize);
        }

        @Override
        public LargestUnique addInput(LargestUnique heap, T input) {
            try {
                heap.add(ApproximateUniqueCombineFn.hash(input, this.coder));
                return heap;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public LargestUnique mergeAccumulators(Iterable<LargestUnique> heaps) {
            Iterator<LargestUnique> iterator = heaps.iterator();
            LargestUnique heap = iterator.next();
            while (iterator.hasNext()) {
                long hash;
                List<Long> largestHashes = iterator.next().extractOrderedList();
                Iterator<Long> iterator2 = largestHashes.iterator();
                while (iterator2.hasNext() && heap.add(hash = iterator2.next().longValue())) {
                }
            }
            return heap;
        }

        @Override
        public Long extractOutput(LargestUnique heap) {
            List<Long> largestHashes = heap.extractOrderedList();
            if ((long)largestHashes.size() < this.sampleSize) {
                return largestHashes.size();
            }
            long smallestSampleHash = largestHashes.get(largestHashes.size() - 1);
            double sampleSpaceSize = 9.223372036854776E18 - (double)smallestSampleHash;
            double estimate = Math.log1p((double)(-this.sampleSize) / sampleSpaceSize) / Math.log1p(-1.0 / sampleSpaceSize) * 1.8446744073709552E19 / sampleSpaceSize;
            return Math.round(estimate);
        }

        @Override
        public Coder<LargestUnique> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return SerializableCoder.of(LargestUnique.class);
        }

        static <T> long hash(T element, Coder<T> coder) throws CoderException, IOException {
            try (HashingOutputStream stream = new HashingOutputStream(Hashing.murmur3_128(), ByteStreams.nullOutputStream());){
                coder.encode(element, stream, Coder.Context.OUTER);
                long l = stream.hash().asLong();
                return l;
            }
        }

        public static class LargestUnique
        implements Serializable {
            private PriorityQueue<Long> heap = new PriorityQueue();
            private final long sampleSize;

            public LargestUnique(long sampleSize) {
                this.sampleSize = sampleSize;
            }

            public boolean add(Long value) {
                if (this.heap.contains(value)) {
                    return true;
                }
                if ((long)this.heap.size() < this.sampleSize) {
                    this.heap.add(value);
                    return true;
                }
                if (value > (Long)this.heap.element()) {
                    this.heap.remove();
                    this.heap.add(value);
                    return true;
                }
                return false;
            }

            public List<Long> extractOrderedList() {
                Long[] array = new Long[this.heap.size()];
                for (int i = this.heap.size() - 1; i >= 0; --i) {
                    array[i] = (Long)this.heap.remove();
                }
                return Arrays.asList(array);
            }
        }
    }

    static class PerKey<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Long>>> {
        private final long sampleSize;
        @Nullable
        private final Double maximumEstimationError;

        public PerKey(int sampleSize) {
            if (sampleSize < 16) {
                throw new IllegalArgumentException("ApproximateUnique needs a sampleSize >= 16 for an estimation error <= 50%.  In general, the estimation error is about 2 / sqrt(sampleSize).");
            }
            this.sampleSize = sampleSize;
            this.maximumEstimationError = null;
        }

        public PerKey(double estimationError) {
            if (estimationError < 0.01 || estimationError > 0.5) {
                throw new IllegalArgumentException("ApproximateUnique.PerKey needs an estimation error between 1% (0.01) and 50% (0.5).");
            }
            this.sampleSize = ApproximateUnique.sampleSizeFromEstimationError(estimationError);
            this.maximumEstimationError = estimationError;
        }

        @Override
        public PCollection<KV<K, Long>> apply(PCollection<KV<K, V>> input) {
            Coder<KV<K, V>> inputCoder = input.getCoder();
            if (!(inputCoder instanceof KvCoder)) {
                throw new IllegalStateException("ApproximateUnique.PerKey requires its input to use KvCoder");
            }
            Coder coder = ((KvCoder)inputCoder).getValueCoder();
            return (PCollection)input.apply(Combine.perKey(new ApproximateUniqueCombineFn(this.sampleSize, coder).asKeyedFn()));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ApproximateUnique.populateDisplayData(builder, this.sampleSize, this.maximumEstimationError);
        }
    }

    static class Globally<T>
    extends PTransform<PCollection<T>, PCollection<Long>> {
        private final long sampleSize;
        @Nullable
        private final Double maximumEstimationError;

        public Globally(int sampleSize) {
            if (sampleSize < 16) {
                throw new IllegalArgumentException("ApproximateUnique needs a sampleSize >= 16 for an estimation error <= 50%.  In general, the estimation error is about 2 / sqrt(sampleSize).");
            }
            this.sampleSize = sampleSize;
            this.maximumEstimationError = null;
        }

        public Globally(double maximumEstimationError) {
            if (maximumEstimationError < 0.01 || maximumEstimationError > 0.5) {
                throw new IllegalArgumentException("ApproximateUnique needs an estimation error between 1% (0.01) and 50% (0.5).");
            }
            this.sampleSize = ApproximateUnique.sampleSizeFromEstimationError(maximumEstimationError);
            this.maximumEstimationError = maximumEstimationError;
        }

        @Override
        public PCollection<Long> apply(PCollection<T> input) {
            Coder<T> coder = input.getCoder();
            return (PCollection)input.apply(Combine.globally(new ApproximateUniqueCombineFn<T>(this.sampleSize, coder)));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ApproximateUnique.populateDisplayData(builder, this.sampleSize, this.maximumEstimationError);
        }
    }
}

