/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Supplier;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import java.io.Serializable;
import java.util.Collection;

final class WindowSupplier
implements Supplier<Collection<BoundedWindow>>,
Serializable {
    private final Coder<? extends BoundedWindow> coder;
    private final Collection<byte[]> encodedWindows;
    private transient Collection<BoundedWindow> windows;

    public static <W extends BoundedWindow> WindowSupplier of(Coder<W> coder, Iterable<W> windows) {
        ImmutableSet.Builder windowsBuilder = ImmutableSet.builder();
        for (BoundedWindow window : windows) {
            try {
                windowsBuilder.add((Object)CoderUtils.encodeToByteArray(coder, window));
            }
            catch (CoderException e) {
                throw new IllegalArgumentException("Could not encode provided windows with the provided window coder", e);
            }
        }
        return new WindowSupplier(coder, windowsBuilder.build());
    }

    private WindowSupplier(Coder<? extends BoundedWindow> coder, Collection<byte[]> encodedWindows) {
        this.coder = coder;
        this.encodedWindows = encodedWindows;
    }

    @Override
    public Collection<BoundedWindow> get() {
        if (this.windows == null) {
            this.decodeWindows();
        }
        return this.windows;
    }

    private synchronized void decodeWindows() {
        if (this.windows == null) {
            ImmutableList.Builder windowsBuilder = ImmutableList.builder();
            for (byte[] encoded : this.encodedWindows) {
                try {
                    windowsBuilder.add(CoderUtils.decodeFromByteArray(this.coder, encoded));
                }
                catch (CoderException e) {
                    throw new IllegalArgumentException("Could not decode provided windows with the provided window coder", e);
                }
            }
            this.windows = windowsBuilder.build();
        }
    }
}

