/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Supplier;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.testing.WindowSupplier;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.NonMergingWindowFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.joda.time.Instant;

final class StaticWindows
extends NonMergingWindowFn<Object, BoundedWindow> {
    private final Supplier<Collection<BoundedWindow>> windows;
    private final Coder<BoundedWindow> coder;
    private final boolean onlyExisting;

    private StaticWindows(Supplier<Collection<BoundedWindow>> windows, Coder<BoundedWindow> coder, boolean onlyExisting) {
        this.windows = windows;
        this.coder = coder;
        this.onlyExisting = onlyExisting;
    }

    public static <W extends BoundedWindow> StaticWindows of(Coder<W> coder, Iterable<W> windows) {
        Preconditions.checkArgument(!Iterables.isEmpty(windows), "Input windows to StaticWindows may not be empty");
        StaticWindows windowFn = new StaticWindows(WindowSupplier.of(coder, windows), coder, false);
        return windowFn;
    }

    public static <W extends BoundedWindow> StaticWindows of(Coder<W> coder, W window) {
        return StaticWindows.of(coder, Collections.singleton(window));
    }

    public StaticWindows intoOnlyExisting() {
        return new StaticWindows(this.windows, this.coder, true);
    }

    public Collection<BoundedWindow> getWindows() {
        return this.windows.get();
    }

    @Override
    public Collection<BoundedWindow> assignWindows(WindowFn.AssignContext c) throws Exception {
        if (this.onlyExisting) {
            Preconditions.checkArgument(this.windows.get().containsAll(c.windows()), "Tried to assign windows to an element that is not already windowed into a provided window when onlyExisting is set to true");
            return ImmutableList.copyOf(c.windows());
        }
        return this.getWindows();
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        if (!(other instanceof StaticWindows)) {
            return false;
        }
        StaticWindows that = (StaticWindows)other;
        return Objects.equals(this.windows.get(), that.windows.get());
    }

    @Override
    public Coder<BoundedWindow> windowCoder() {
        return this.coder;
    }

    @Override
    public BoundedWindow getSideInputWindow(BoundedWindow window) {
        Preconditions.checkArgument(this.windows.get().contains(window), "StaticWindows only supports side input windows for main input windows that it contains");
        return window;
    }

    @Override
    public Instant getOutputTime(Instant inputTimestamp, BoundedWindow window) {
        return inputTimestamp;
    }
}

