/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.ByteArrayCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.ListCoder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.coders.VarIntCoder;
import com.google.cloud.dataflow.sdk.coders.VarLongCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.hash.HashFunction;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.hash.Hashing;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.RandomAccessData;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.VarInt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class IsmFormat {
    private static final int HASH_SEED = 1225801234;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32(1225801234);
    static final int SHARD_BITS = 127;
    private static final Object METADATA_KEY = new Object(){

        public String toString() {
            return "META";
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return -1248902349;
        }
    };
    public static final Coder<List<IsmShard>> ISM_SHARD_INDEX_CODER = ListCoder.of(IsmShardCoder.of());

    static void validateCoderIsCompatible(IsmRecordCoder<?> coder) {
        for (Coder<?> keyComponentCoder : coder.getKeyComponentCoders()) {
            try {
                keyComponentCoder.verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new IllegalArgumentException(String.format("Key component coder %s is expected to be deterministic.", keyComponentCoder), e);
            }
        }
    }

    public static boolean isMetadataKey(List<?> keyComponents) {
        for (Object keyComponent : keyComponents) {
            if (keyComponent != METADATA_KEY) continue;
            return true;
        }
        return false;
    }

    public static Object getMetadataKey() {
        return METADATA_KEY;
    }

    static final class FooterCoder
    extends AtomicCoder<Footer> {
        private static final FooterCoder INSTANCE = new FooterCoder();

        FooterCoder() {
        }

        @JsonCreator
        public static FooterCoder of() {
            return INSTANCE;
        }

        @Override
        public void encode(Footer value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            DataOutputStream dataOut = new DataOutputStream(outStream);
            dataOut.writeLong(value.indexPosition);
            dataOut.writeLong(value.bloomFilterPosition);
            dataOut.writeLong(value.numberOfKeys);
            dataOut.write(2);
        }

        @Override
        public Footer decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            DataInputStream dataIn = new DataInputStream(inStream);
            Footer footer = new Footer(dataIn.readLong(), dataIn.readLong(), dataIn.readLong());
            int version = dataIn.read();
            if (version != 2) {
                throw new IOException("Unknown version " + version + ". " + "Only version 2 is currently supported.");
            }
            return footer;
        }

        @Override
        public boolean consistentWithEquals() {
            return true;
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(Footer value, Coder.Context context) {
            return true;
        }

        @Override
        protected long getEncodedElementByteSize(Footer value, Coder.Context context) throws Exception {
            return 25L;
        }
    }

    static class Footer {
        static final int LONG_BYTES = 8;
        static final int FIXED_LENGTH = 25;
        static final byte VERSION = 2;
        private final long indexPosition;
        private final long bloomFilterPosition;
        private final long numberOfKeys;

        Footer(long indexPosition, long bloomFilterPosition, long numberOfKeys) {
            this.indexPosition = indexPosition;
            this.bloomFilterPosition = bloomFilterPosition;
            this.numberOfKeys = numberOfKeys;
        }

        public long getIndexPosition() {
            return this.indexPosition;
        }

        public long getBloomFilterPosition() {
            return this.bloomFilterPosition;
        }

        public long getNumberOfKeys() {
            return this.numberOfKeys;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Footer)) {
                return false;
            }
            Footer footer = (Footer)other;
            return this.indexPosition == footer.indexPosition && this.bloomFilterPosition == footer.bloomFilterPosition && this.numberOfKeys == footer.numberOfKeys;
        }

        public int hashCode() {
            return Objects.hashCode(this.indexPosition, this.bloomFilterPosition, this.numberOfKeys);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("version", 2).add("indexPosition", this.indexPosition).add("bloomFilterPosition", this.bloomFilterPosition).add("numberOfKeys", this.numberOfKeys).toString();
        }
    }

    static final class KeyPrefixCoder
    extends AtomicCoder<KeyPrefix> {
        private static final KeyPrefixCoder INSTANCE = new KeyPrefixCoder();

        KeyPrefixCoder() {
        }

        @JsonCreator
        public static KeyPrefixCoder of() {
            return INSTANCE;
        }

        @Override
        public void encode(KeyPrefix value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            VarInt.encode(value.sharedKeySize, outStream);
            VarInt.encode(value.unsharedKeySize, outStream);
        }

        @Override
        public KeyPrefix decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            return new KeyPrefix(VarInt.decodeInt(inStream), VarInt.decodeInt(inStream));
        }

        @Override
        public boolean consistentWithEquals() {
            return true;
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(KeyPrefix value, Coder.Context context) {
            return true;
        }

        @Override
        protected long getEncodedElementByteSize(KeyPrefix value, Coder.Context context) throws Exception {
            Preconditions.checkNotNull(value);
            return VarInt.getLength(value.sharedKeySize) + VarInt.getLength(value.unsharedKeySize);
        }
    }

    static class KeyPrefix {
        private final int sharedKeySize;
        private final int unsharedKeySize;

        KeyPrefix(int sharedBytes, int unsharedBytes) {
            this.sharedKeySize = sharedBytes;
            this.unsharedKeySize = unsharedBytes;
        }

        public int getSharedKeySize() {
            return this.sharedKeySize;
        }

        public int getUnsharedKeySize() {
            return this.unsharedKeySize;
        }

        public int hashCode() {
            return Objects.hashCode(this.sharedKeySize, this.unsharedKeySize);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof KeyPrefix)) {
                return false;
            }
            KeyPrefix keyPrefix = (KeyPrefix)other;
            return this.sharedKeySize == keyPrefix.sharedKeySize && this.unsharedKeySize == keyPrefix.unsharedKeySize;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("sharedKeySize", this.sharedKeySize).add("unsharedKeySize", this.unsharedKeySize).toString();
        }
    }

    public static class IsmShardCoder
    extends AtomicCoder<IsmShard> {
        private static final IsmShardCoder INSTANCE = new IsmShardCoder();

        @JsonCreator
        public static IsmShardCoder of() {
            return INSTANCE;
        }

        private IsmShardCoder() {
        }

        @Override
        public void encode(IsmShard value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            Preconditions.checkState(value.getIndexOffset() >= 0L, "%s attempting to be written without index offset.", value);
            VarIntCoder.of().encode(value.getId(), outStream, context.nested());
            VarLongCoder.of().encode(value.getBlockOffset(), outStream, context.nested());
            VarLongCoder.of().encode(value.getIndexOffset(), outStream, context.nested());
        }

        @Override
        public IsmShard decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            return IsmShard.of(VarIntCoder.of().decode(inStream, context), VarLongCoder.of().decode(inStream, context), VarLongCoder.of().decode(inStream, context));
        }

        @Override
        public boolean consistentWithEquals() {
            return true;
        }
    }

    public static class IsmShard {
        private final int id;
        private final long blockOffset;
        private final long indexOffset;

        public static IsmShard of(int id, long blockOffset) {
            IsmShard ismShard = new IsmShard(id, blockOffset, -1L);
            Preconditions.checkState(id >= 0, "%s attempting to be written with negative shard id.", ismShard);
            Preconditions.checkState(blockOffset >= 0L, "%s attempting to be written with negative block offset.", ismShard);
            return ismShard;
        }

        public static IsmShard of(int id, long blockOffset, long indexOffset) {
            IsmShard ismShard = new IsmShard(id, blockOffset, indexOffset);
            Preconditions.checkState(id >= 0, "%s attempting to be written with negative shard id.", ismShard);
            Preconditions.checkState(blockOffset >= 0L, "%s attempting to be written with negative block offset.", ismShard);
            Preconditions.checkState(indexOffset >= 0L, "%s attempting to be written with negative index offset.", ismShard);
            return ismShard;
        }

        private IsmShard(int id, long blockOffset, long indexOffset) {
            this.id = id;
            this.blockOffset = blockOffset;
            this.indexOffset = indexOffset;
        }

        public int getId() {
            return this.id;
        }

        public long getBlockOffset() {
            return this.blockOffset;
        }

        public long getIndexOffset() {
            Preconditions.checkState(this.indexOffset >= 0L, "Unable to fetch index offset because it was never specified.");
            return this.indexOffset;
        }

        public IsmShard withIndexOffset(long indexOffset) {
            return IsmShard.of(this.id, this.blockOffset, indexOffset);
        }

        public String toString() {
            return MoreObjects.toStringHelper(IsmShard.class).add("id", this.id).add("blockOffset", this.blockOffset).add("indexOffset", this.indexOffset).toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IsmShard)) {
                return false;
            }
            IsmShard other = (IsmShard)obj;
            return Objects.equal(this.id, other.id) && Objects.equal(this.blockOffset, other.blockOffset) && Objects.equal(this.indexOffset, other.indexOffset);
        }

        public int hashCode() {
            return Objects.hashCode(this.id, this.blockOffset, this.indexOffset);
        }
    }

    public static class MetadataKeyCoder<K>
    extends StandardCoder<K> {
        private final Coder<K> keyCoder;

        public static <K> MetadataKeyCoder<K> of(Coder<K> keyCoder) {
            Preconditions.checkNotNull(keyCoder);
            return new MetadataKeyCoder<K>(keyCoder);
        }

        @JsonCreator
        public static MetadataKeyCoder<?> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
            Preconditions.checkArgument(components.size() == 1, "Expecting one component, got " + components.size());
            return MetadataKeyCoder.of(components.get(0));
        }

        private MetadataKeyCoder(Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
        }

        public Coder<K> getKeyCoder() {
            return this.keyCoder;
        }

        @Override
        public void encode(K value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            if (value == METADATA_KEY) {
                outStream.write(0);
            } else {
                outStream.write(1);
                this.keyCoder.encode(value, outStream, context.nested());
            }
        }

        @Override
        public K decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            int marker = inStream.read();
            if (marker == 0) {
                return (K)IsmFormat.getMetadataKey();
            }
            if (marker == 1) {
                return this.keyCoder.decode(inStream, context.nested());
            }
            throw new CoderException(String.format("Expected marker but got %s.", marker));
        }

        @Override
        public List<Coder<?>> getCoderArguments() {
            return ImmutableList.of(this.keyCoder);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.verifyDeterministic("Expected key coder to be deterministic", this.keyCoder);
        }
    }

    public static class IsmRecordCoder<V>
    extends StandardCoder<IsmRecord<V>> {
        private final int numberOfShardKeyCoders;
        private final int numberOfMetadataShardKeyCoders;
        private final List<Coder<?>> keyComponentCoders;
        private final Coder<V> valueCoder;

        public static <V> IsmRecordCoder<V> of(int numberOfShardKeyCoders, int numberOfMetadataShardKeyCoders, List<Coder<?>> keyComponentCoders, Coder<V> valueCoder) {
            Preconditions.checkNotNull(keyComponentCoders);
            Preconditions.checkArgument(keyComponentCoders.size() > 0);
            Preconditions.checkArgument(numberOfShardKeyCoders > 0);
            Preconditions.checkArgument(numberOfShardKeyCoders <= keyComponentCoders.size());
            Preconditions.checkArgument(numberOfMetadataShardKeyCoders <= keyComponentCoders.size());
            return new IsmRecordCoder<V>(numberOfShardKeyCoders, numberOfMetadataShardKeyCoders, keyComponentCoders, valueCoder);
        }

        @JsonCreator
        public static IsmRecordCoder<?> of(@JsonProperty(value="num_shard_coders") int numberOfShardCoders, @JsonProperty(value="num_metadata_shard_coders") int numberOfMetadataShardCoders, @JsonProperty(value="component_encodings") List<Coder<?>> components) {
            Preconditions.checkArgument(components.size() >= 2, "Expecting at least 2 components, got " + components.size());
            return IsmRecordCoder.of(numberOfShardCoders, numberOfMetadataShardCoders, components.subList(0, components.size() - 1), components.get(components.size() - 1));
        }

        private IsmRecordCoder(int numberOfShardKeyCoders, int numberOfMetadataShardKeyCoders, List<Coder<?>> keyComponentCoders, Coder<V> valueCoder) {
            this.numberOfShardKeyCoders = numberOfShardKeyCoders;
            this.numberOfMetadataShardKeyCoders = numberOfMetadataShardKeyCoders;
            this.keyComponentCoders = keyComponentCoders;
            this.valueCoder = valueCoder;
        }

        public List<Coder<?>> getKeyComponentCoders() {
            return this.keyComponentCoders;
        }

        public Coder getKeyComponentCoder(int index) {
            return this.keyComponentCoders.get(index);
        }

        public Coder<V> getValueCoder() {
            return this.valueCoder;
        }

        @Override
        public void encode(IsmRecord<V> value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            if (value.getKeyComponents().size() != this.keyComponentCoders.size()) {
                throw new CoderException(String.format("Expected %s key component(s) but received key component(s) %s.", this.keyComponentCoders.size(), value.getKeyComponents()));
            }
            for (int i = 0; i < this.keyComponentCoders.size(); ++i) {
                this.getKeyComponentCoder(i).encode(value.getKeyComponent(i), outStream, context.nested());
            }
            if (IsmFormat.isMetadataKey(value.getKeyComponents())) {
                ByteArrayCoder.of().encode(value.getMetadata(), outStream, context.nested());
            } else {
                this.valueCoder.encode(value.getValue(), outStream, context.nested());
            }
        }

        @Override
        public IsmRecord<V> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            ArrayList keyComponents = new ArrayList(this.keyComponentCoders.size());
            for (Coder<?> keyCoder : this.keyComponentCoders) {
                keyComponents.add(keyCoder.decode(inStream, context.nested()));
            }
            if (IsmFormat.isMetadataKey(keyComponents)) {
                return IsmRecord.meta(keyComponents, ByteArrayCoder.of().decode(inStream, context.nested()));
            }
            return IsmRecord.of(keyComponents, this.valueCoder.decode(inStream, context.nested()));
        }

        int getNumberOfShardKeyCoders(List<?> keyComponents) {
            if (IsmFormat.isMetadataKey(keyComponents)) {
                return this.numberOfMetadataShardKeyCoders;
            }
            return this.numberOfShardKeyCoders;
        }

        public <V, T> int hash(List<?> keyComponents) {
            return this.encodeAndHash(keyComponents, new RandomAccessData(), new ArrayList<Integer>());
        }

        <V, T> int encodeAndHash(List<?> keyComponents, RandomAccessData keyBytesToMutate) {
            return this.encodeAndHash(keyComponents, keyBytesToMutate, new ArrayList<Integer>());
        }

        <V, T> int encodeAndHash(List<?> keyComponents, RandomAccessData keyBytesToMutate, List<Integer> keyComponentByteOffsetsToMutate) {
            int shardOffset;
            int numberOfKeyCodersToUse;
            Preconditions.checkNotNull(keyComponents);
            Preconditions.checkArgument(keyComponents.size() <= this.keyComponentCoders.size(), "Expected at most %s key component(s) but received %s.", this.keyComponentCoders.size(), keyComponents);
            if (IsmFormat.isMetadataKey(keyComponents)) {
                numberOfKeyCodersToUse = this.numberOfMetadataShardKeyCoders;
                shardOffset = 128;
            } else {
                numberOfKeyCodersToUse = this.numberOfShardKeyCoders;
                shardOffset = 0;
            }
            Preconditions.checkArgument(numberOfKeyCodersToUse <= keyComponents.size(), "Expected at least %s key component(s) but received %s.", this.numberOfShardKeyCoders, keyComponents);
            try {
                for (int i = 0; i < numberOfKeyCodersToUse; ++i) {
                    this.getKeyComponentCoder(i).encode(keyComponents.get(i), keyBytesToMutate.asOutputStream(), Coder.Context.NESTED);
                    keyComponentByteOffsetsToMutate.add(keyBytesToMutate.size());
                }
                int rval = HASH_FUNCTION.hashBytes(keyBytesToMutate.array(), 0, keyBytesToMutate.size()).asInt() & 0x7F;
                rval += shardOffset;
                for (int i = numberOfKeyCodersToUse; i < keyComponents.size(); ++i) {
                    this.getKeyComponentCoder(i).encode(keyComponents.get(i), keyBytesToMutate.asOutputStream(), Coder.Context.NESTED);
                    keyComponentByteOffsetsToMutate.add(keyBytesToMutate.size());
                }
                return rval;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to hash %s with coder %s", keyComponents, this), e);
            }
        }

        @Override
        public List<Coder<?>> getCoderArguments() {
            return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.keyComponentCoders)).add(this.valueCoder)).build();
        }

        @Override
        public CloudObject asCloudObject() {
            CloudObject cloudObject = super.asCloudObject();
            Structs.addLong((Map<String, Object>)((Object)cloudObject), "num_shard_coders", this.numberOfShardKeyCoders);
            Structs.addLong((Map<String, Object>)((Object)cloudObject), "num_metadata_shard_coders", this.numberOfMetadataShardKeyCoders);
            return cloudObject;
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.verifyDeterministic("Key component coders expected to be deterministic.", this.keyComponentCoders);
            this.verifyDeterministic("Value coder expected to be deterministic.", this.valueCoder);
        }

        @Override
        public boolean consistentWithEquals() {
            for (Coder<?> keyComponentCoder : this.keyComponentCoders) {
                if (keyComponentCoder.consistentWithEquals()) continue;
                return false;
            }
            return this.valueCoder.consistentWithEquals();
        }

        @Override
        public Object structuralValue(IsmRecord<V> record) throws Exception {
            Preconditions.checkState(record.getKeyComponents().size() == this.keyComponentCoders.size(), "Expected the number of key component coders %s to match the number of key components %s.", this.keyComponentCoders.size(), record.getKeyComponents());
            if (record != null && this.consistentWithEquals()) {
                ArrayList<Object> keyComponentStructuralValues = new ArrayList<Object>();
                for (int i = 0; i < this.keyComponentCoders.size(); ++i) {
                    keyComponentStructuralValues.add(this.getKeyComponentCoder(i).structuralValue(record.getKeyComponent(i)));
                }
                if (IsmFormat.isMetadataKey(record.getKeyComponents())) {
                    return IsmRecord.meta(keyComponentStructuralValues, record.getMetadata());
                }
                return IsmRecord.of(keyComponentStructuralValues, this.valueCoder.structuralValue(record.getValue()));
            }
            return super.structuralValue(record);
        }
    }

    public static class IsmRecord<V> {
        private final List<?> keyComponents;
        @Nullable
        private final V value;
        @Nullable
        private final byte[] metadata;

        public static <V> IsmRecord<V> of(List<?> keyComponents, V value) {
            Preconditions.checkNotNull(keyComponents);
            Preconditions.checkArgument(!keyComponents.isEmpty(), "Expected non-empty list of key components.");
            Preconditions.checkArgument(!IsmFormat.isMetadataKey(keyComponents), "Expected key components to not contain metadata key.");
            return new IsmRecord<V>(keyComponents, value, null);
        }

        public static <V> IsmRecord<V> meta(List<?> keyComponents, byte[] metadata) {
            Preconditions.checkNotNull(keyComponents);
            Preconditions.checkNotNull(metadata);
            Preconditions.checkArgument(!keyComponents.isEmpty(), "Expected non-empty list of key components.");
            Preconditions.checkArgument(IsmFormat.isMetadataKey(keyComponents), "Expected key components to contain metadata key.");
            return new IsmRecord<Object>(keyComponents, null, metadata);
        }

        private IsmRecord(List<?> keyComponents, V value, byte[] metadata) {
            this.keyComponents = keyComponents;
            this.value = value;
            this.metadata = metadata;
        }

        public List<?> getKeyComponents() {
            return this.keyComponents;
        }

        public Object getKeyComponent(int index) {
            return this.keyComponents.get(index);
        }

        public V getValue() {
            Preconditions.checkState(!IsmFormat.isMetadataKey(this.keyComponents), "This is a metadata record and not a value record.");
            return this.value;
        }

        public byte[] getMetadata() {
            Preconditions.checkState(IsmFormat.isMetadataKey(this.keyComponents), "This is a value record and not a metadata record.");
            return this.metadata;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IsmRecord)) {
                return false;
            }
            IsmRecord other = (IsmRecord)obj;
            return Objects.equal(this.keyComponents, other.keyComponents) && Objects.equal(this.value, other.value) && Arrays.equals(this.metadata, other.metadata);
        }

        public int hashCode() {
            return Objects.hashCode(this.keyComponents, this.value, Arrays.hashCode(this.metadata));
        }

        public String toString() {
            MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper(IsmRecord.class).add("keyComponents", this.keyComponents);
            if (IsmFormat.isMetadataKey(this.keyComponents)) {
                builder.add("metadata", this.metadata);
            } else {
                builder.add("value", this.value);
            }
            return builder.toString();
        }
    }
}

