/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.inprocess.CommittedResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.CompletionCallback;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessEvaluationContext;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.ModelEnforcement;
import com.google.cloud.dataflow.sdk.runners.inprocess.ModelEnforcementFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluator;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformExecutorService;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

class TransformExecutor<T>
implements Runnable {
    private final TransformEvaluatorFactory evaluatorFactory;
    private final Iterable<? extends ModelEnforcementFactory> modelEnforcements;
    private final InProcessEvaluationContext evaluationContext;
    private final AppliedPTransform<?, ?, ?> transform;
    private final InProcessPipelineRunner.CommittedBundle<T> inputBundle;
    private final CompletionCallback onComplete;
    private final TransformExecutorService transformEvaluationState;
    private final AtomicReference<Thread> thread;

    public static <T> TransformExecutor<T> create(TransformEvaluatorFactory factory, Iterable<? extends ModelEnforcementFactory> modelEnforcements, InProcessEvaluationContext evaluationContext, InProcessPipelineRunner.CommittedBundle<T> inputBundle, AppliedPTransform<?, ?, ?> transform, CompletionCallback completionCallback, TransformExecutorService transformEvaluationState) {
        return new TransformExecutor<T>(factory, modelEnforcements, evaluationContext, inputBundle, transform, completionCallback, transformEvaluationState);
    }

    private TransformExecutor(TransformEvaluatorFactory factory, Iterable<? extends ModelEnforcementFactory> modelEnforcements, InProcessEvaluationContext evaluationContext, InProcessPipelineRunner.CommittedBundle<T> inputBundle, AppliedPTransform<?, ?, ?> transform, CompletionCallback completionCallback, TransformExecutorService transformEvaluationState) {
        this.evaluatorFactory = factory;
        this.modelEnforcements = modelEnforcements;
        this.evaluationContext = evaluationContext;
        this.inputBundle = inputBundle;
        this.transform = transform;
        this.onComplete = completionCallback;
        this.transformEvaluationState = transformEvaluationState;
        this.thread = new AtomicReference();
    }

    @Override
    public void run() {
        Preconditions.checkState(this.thread.compareAndSet(null, Thread.currentThread()), "Tried to execute %s for %s on thread %s, but is already executing on thread %s", TransformExecutor.class.getSimpleName(), this.transform.getFullName(), Thread.currentThread(), this.thread.get());
        try {
            ArrayList<ModelEnforcement<T>> enforcements = new ArrayList<ModelEnforcement<T>>();
            for (ModelEnforcementFactory modelEnforcementFactory : this.modelEnforcements) {
                ModelEnforcement<T> enforcement = modelEnforcementFactory.forBundle(this.inputBundle, this.transform);
                enforcements.add(enforcement);
            }
            TransformEvaluator evaluator = this.evaluatorFactory.forApplication(this.transform, this.inputBundle, this.evaluationContext);
            if (evaluator == null) {
                this.onComplete.handleEmpty(this.transform);
                return;
            }
            this.processElements(evaluator, enforcements);
            this.finishBundle(evaluator, enforcements);
        }
        catch (Throwable t) {
            this.onComplete.handleThrowable(this.inputBundle, t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            this.transformEvaluationState.complete(this);
        }
    }

    private void processElements(TransformEvaluator<T> evaluator, Collection<ModelEnforcement<T>> enforcements) throws Exception {
        if (this.inputBundle != null) {
            for (WindowedValue<T> value : this.inputBundle.getElements()) {
                for (ModelEnforcement<T> enforcement : enforcements) {
                    enforcement.beforeElement(value);
                }
                evaluator.processElement(value);
                for (ModelEnforcement<T> enforcement : enforcements) {
                    enforcement.afterElement(value);
                }
            }
        }
    }

    private InProcessTransformResult finishBundle(TransformEvaluator<T> evaluator, Collection<ModelEnforcement<T>> enforcements) throws Exception {
        InProcessTransformResult result = evaluator.finishBundle();
        CommittedResult outputs = this.onComplete.handleResult(this.inputBundle, result);
        for (ModelEnforcement<T> enforcement : enforcements) {
            enforcement.afterFinish(this.inputBundle, result, outputs.getOutputs());
        }
        return result;
    }

    @Nullable
    public Thread getThread() {
        return this.thread.get();
    }
}

