/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.runners.inprocess.AutoValue_StepTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.CommittedResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.InMemoryWatermarkManager;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessTransformResult;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.state.CopyOnAccessInMemoryStateInternals;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.Instant;

public abstract class StepTransformResult
implements InProcessTransformResult {
    @Override
    public abstract AppliedPTransform<?, ?, ?> getTransform();

    @Override
    public abstract Iterable<? extends InProcessPipelineRunner.UncommittedBundle<?>> getOutputBundles();

    @Override
    public abstract Iterable<? extends WindowedValue<?>> getUnprocessedElements();

    @Override
    @Nullable
    public abstract CounterSet getCounters();

    @Override
    public abstract Instant getWatermarkHold();

    @Override
    @Nullable
    public abstract CopyOnAccessInMemoryStateInternals<?> getState();

    @Override
    public abstract InMemoryWatermarkManager.TimerUpdate getTimerUpdate();

    @Override
    public abstract Set<CommittedResult.OutputType> getOutputTypes();

    public static Builder withHold(AppliedPTransform<?, ?, ?> transform, Instant watermarkHold) {
        return new Builder(transform, watermarkHold);
    }

    public static Builder withoutHold(AppliedPTransform<?, ?, ?> transform) {
        return new Builder(transform, BoundedWindow.TIMESTAMP_MAX_VALUE);
    }

    public static class Builder {
        private final AppliedPTransform<?, ?, ?> transform;
        private final ImmutableList.Builder<InProcessPipelineRunner.UncommittedBundle<?>> bundlesBuilder;
        private final ImmutableList.Builder<WindowedValue<?>> unprocessedElementsBuilder;
        private CopyOnAccessInMemoryStateInternals<?> state;
        private InMemoryWatermarkManager.TimerUpdate timerUpdate;
        private CounterSet counters;
        private final Set<CommittedResult.OutputType> producedOutputs;
        private final Instant watermarkHold;

        private Builder(AppliedPTransform<?, ?, ?> transform, Instant watermarkHold) {
            this.transform = transform;
            this.watermarkHold = watermarkHold;
            this.bundlesBuilder = ImmutableList.builder();
            this.producedOutputs = EnumSet.noneOf(CommittedResult.OutputType.class);
            this.unprocessedElementsBuilder = ImmutableList.builder();
            this.timerUpdate = InMemoryWatermarkManager.TimerUpdate.builder(null).build();
        }

        public StepTransformResult build() {
            return new AutoValue_StepTransformResult(this.transform, this.bundlesBuilder.build(), this.unprocessedElementsBuilder.build(), this.counters, this.watermarkHold, this.state, this.timerUpdate, this.producedOutputs);
        }

        public Builder withCounters(CounterSet counters) {
            this.counters = counters;
            return this;
        }

        public Builder withState(CopyOnAccessInMemoryStateInternals<?> state) {
            this.state = state;
            return this;
        }

        public Builder withTimerUpdate(InMemoryWatermarkManager.TimerUpdate timerUpdate) {
            this.timerUpdate = timerUpdate;
            return this;
        }

        public Builder addUnprocessedElements(Iterable<? extends WindowedValue<?>> unprocessed) {
            this.unprocessedElementsBuilder.addAll(unprocessed);
            return this;
        }

        public Builder addOutput(InProcessPipelineRunner.UncommittedBundle<?> outputBundle, InProcessPipelineRunner.UncommittedBundle<?> ... outputBundles) {
            this.bundlesBuilder.add((Object)outputBundle);
            this.bundlesBuilder.add(outputBundles);
            return this;
        }

        public Builder addOutput(Collection<InProcessPipelineRunner.UncommittedBundle<?>> outputBundles) {
            this.bundlesBuilder.addAll(outputBundles);
            return this;
        }

        public Builder withAdditionalOutput(CommittedResult.OutputType producedAdditionalOutput) {
            this.producedOutputs.add(producedAdditionalOutput);
            return this;
        }
    }
}

